/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class ArchiveResource
extends Resource {
    private static final int NULL_ARCHIVE = Resource.getMagicNumber("null archive".getBytes());
    private Resource archive;
    private boolean haveEntry = false;
    private boolean modeSet = false;
    private int mode = 0;

    public ArchiveResource() {
    }

    public ArchiveResource(File a2) {
        this(a2, false);
    }

    public ArchiveResource(File a2, boolean withEntry) {
        this.setArchive(a2);
        this.haveEntry = withEntry;
    }

    public ArchiveResource(Resource a2, boolean withEntry) {
        this.addConfigured(a2);
        this.haveEntry = withEntry;
    }

    public void setArchive(File a2) {
        this.checkAttributesAllowed();
        this.archive = new FileResource(a2);
    }

    public void setMode(int mode) {
        this.checkAttributesAllowed();
        this.mode = mode;
        this.modeSet = true;
    }

    public void addConfigured(ResourceCollection a2) {
        this.checkChildrenAllowed();
        if (this.archive != null) {
            throw new BuildException("you must not specify more than one archive");
        }
        if (a2.size() != 1) {
            throw new BuildException("only single argument resource collections are supported as archives");
        }
        this.archive = (Resource)a2.iterator().next();
    }

    public Resource getArchive() {
        return this.isReference() ? ((ArchiveResource)this.getCheckedRef()).getArchive() : this.archive;
    }

    public long getLastModified() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getLastModified();
        }
        this.checkEntry();
        return super.getLastModified();
    }

    public long getSize() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getSize();
        }
        this.checkEntry();
        return super.getSize();
    }

    public boolean isDirectory() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).isDirectory();
        }
        this.checkEntry();
        return super.isDirectory();
    }

    public boolean isExists() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).isExists();
        }
        this.checkEntry();
        return super.isExists();
    }

    public int getMode() {
        if (this.isReference()) {
            return ((ArchiveResource)this.getCheckedRef()).getMode();
        }
        this.checkEntry();
        return this.mode;
    }

    public void setRefid(Reference r2) {
        if (this.archive != null || this.modeSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r2);
    }

    public int compareTo(Object another) {
        return this.equals(another) ? 0 : super.compareTo(another);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (this.isReference()) {
            return this.getCheckedRef().equals(another);
        }
        if (!another.getClass().equals(this.getClass())) {
            return false;
        }
        ArchiveResource r2 = (ArchiveResource)another;
        return this.getArchive().equals(r2.getArchive()) && this.getName().equals(r2.getName());
    }

    public int hashCode() {
        return super.hashCode() * (this.getArchive() == null ? NULL_ARCHIVE : this.getArchive().hashCode());
    }

    public String toString() {
        return this.isReference() ? this.getCheckedRef().toString() : this.getArchive().toString() + ':' + this.getName();
    }

    private synchronized void checkEntry() throws BuildException {
        if (this.haveEntry) {
            return;
        }
        String name = this.getName();
        if (name == null) {
            throw new BuildException("entry name not set");
        }
        Resource r2 = this.getArchive();
        if (r2 == null) {
            throw new BuildException("archive attribute not set");
        }
        if (!r2.isExists()) {
            throw new BuildException(r2.toString() + " does not exist.");
        }
        if (r2.isDirectory()) {
            throw new BuildException(r2 + " denotes a directory.");
        }
        this.fetchEntry();
        this.haveEntry = true;
    }

    protected abstract void fetchEntry();
}

