/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FailFast;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class BaseResourceCollectionContainer
extends DataType
implements ResourceCollection,
Cloneable {
    private List rc = new ArrayList();
    private Collection coll = null;
    private boolean cache = true;

    public synchronized void setCache(boolean b2) {
        this.cache = b2;
    }

    public synchronized boolean isCache() {
        return this.cache;
    }

    public synchronized void clear() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.rc.clear();
        FailFast.invalidate(this);
        this.coll = null;
        this.setChecked(false);
    }

    public synchronized void add(ResourceCollection c2) throws BuildException {
        Project p2;
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (c2 == null) {
            return;
        }
        if (Project.getProject(c2) == null && (p2 = this.getProject()) != null) {
            p2.setProjectReference(c2);
        }
        this.rc.add(c2);
        FailFast.invalidate(this);
        this.coll = null;
        this.setChecked(false);
    }

    public synchronized void addAll(Collection c2) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        try {
            Iterator i2 = c2.iterator();
            while (i2.hasNext()) {
                this.add((ResourceCollection)i2.next());
            }
        }
        catch (ClassCastException e2) {
            throw new BuildException(e2);
        }
    }

    public final synchronized Iterator iterator() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).iterator();
        }
        this.dieOnCircularReference();
        return new FailFast(this, this.cacheCollection().iterator());
    }

    public synchronized int size() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).size();
        }
        this.dieOnCircularReference();
        return this.cacheCollection().size();
    }

    public synchronized boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((BaseResourceCollectionContainer)this.getCheckedRef()).isFilesystemOnly();
        }
        this.dieOnCircularReference();
        boolean goEarly = true;
        Iterator i2 = this.rc.iterator();
        while (goEarly && i2.hasNext()) {
            goEarly = ((ResourceCollection)i2.next()).isFilesystemOnly();
        }
        if (goEarly) {
            return true;
        }
        i2 = this.cacheCollection().iterator();
        while (i2.hasNext()) {
            if (i2.next() instanceof FileResource) continue;
            return false;
        }
        return true;
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p2) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p2);
        } else {
            Iterator i2 = this.rc.iterator();
            while (i2.hasNext()) {
                Object o2 = i2.next();
                if (!(o2 instanceof DataType)) continue;
                stk.push(o2);
                BaseResourceCollectionContainer.invokeCircularReferenceCheck((DataType)o2, stk, p2);
                stk.pop();
            }
            this.setChecked(true);
        }
    }

    protected final synchronized List getResourceCollections() {
        this.dieOnCircularReference();
        return Collections.unmodifiableList(this.rc);
    }

    protected abstract Collection getCollection();

    public Object clone() {
        try {
            BaseResourceCollectionContainer c2 = (BaseResourceCollectionContainer)super.clone();
            c2.rc = new ArrayList(this.rc);
            c2.coll = null;
            return c2;
        }
        catch (CloneNotSupportedException e2) {
            throw new BuildException(e2);
        }
    }

    public synchronized String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        if (this.cacheCollection().size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator i2 = this.coll.iterator();
        while (i2.hasNext()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(i2.next());
        }
        return sb.toString();
    }

    private synchronized Collection cacheCollection() {
        if (this.coll == null || !this.isCache()) {
            this.coll = this.getCollection();
        }
        return this.coll;
    }
}

