/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResourceIterator;
import org.apache.tools.ant.types.selectors.AbstractSelectorContainer;
import org.apache.tools.ant.types.selectors.FileSelector;

public class Files
extends AbstractSelectorContainer
implements Cloneable,
ResourceCollection {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_SET.iterator();
    private PatternSet defaultPatterns = new PatternSet();
    private Vector additionalPatterns = new Vector();
    private Vector selectors = new Vector();
    private boolean useDefaultExcludes = true;
    private boolean caseSensitive = true;
    private boolean followSymlinks = true;
    private DirectoryScanner ds = null;

    public Files() {
    }

    protected Files(Files f2) {
        this.defaultPatterns = f2.defaultPatterns;
        this.additionalPatterns = f2.additionalPatterns;
        this.selectors = f2.selectors;
        this.useDefaultExcludes = f2.useDefaultExcludes;
        this.caseSensitive = f2.caseSensitive;
        this.followSymlinks = f2.followSymlinks;
        this.ds = f2.ds;
        this.setProject(f2.getProject());
    }

    public void setRefid(Reference r2) throws BuildException {
        if (this.hasPatterns(this.defaultPatterns)) {
            throw this.tooManyAttributes();
        }
        if (!this.additionalPatterns.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        if (!this.selectors.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(r2);
    }

    public synchronized PatternSet createPatternSet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PatternSet patterns = new PatternSet();
        this.additionalPatterns.addElement(patterns);
        this.ds = null;
        return patterns;
    }

    public synchronized PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.ds = null;
        return this.defaultPatterns.createInclude();
    }

    public synchronized PatternSet.NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.ds = null;
        return this.defaultPatterns.createIncludesFile();
    }

    public synchronized PatternSet.NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.ds = null;
        return this.defaultPatterns.createExclude();
    }

    public synchronized PatternSet.NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.ds = null;
        return this.defaultPatterns.createExcludesFile();
    }

    public synchronized void setIncludes(String includes) {
        this.checkAttributesAllowed();
        this.defaultPatterns.setIncludes(includes);
        this.ds = null;
    }

    public synchronized void appendIncludes(String[] includes) {
        this.checkAttributesAllowed();
        if (includes != null) {
            for (int i2 = 0; i2 < includes.length; ++i2) {
                this.defaultPatterns.createInclude().setName(includes[i2]);
            }
            this.ds = null;
        }
    }

    public synchronized void setExcludes(String excludes) {
        this.checkAttributesAllowed();
        this.defaultPatterns.setExcludes(excludes);
        this.ds = null;
    }

    public synchronized void appendExcludes(String[] excludes) {
        this.checkAttributesAllowed();
        if (excludes != null) {
            for (int i2 = 0; i2 < excludes.length; ++i2) {
                this.defaultPatterns.createExclude().setName(excludes[i2]);
            }
            this.ds = null;
        }
    }

    public synchronized void setIncludesfile(File incl) throws BuildException {
        this.checkAttributesAllowed();
        this.defaultPatterns.setIncludesfile(incl);
        this.ds = null;
    }

    public synchronized void setExcludesfile(File excl) throws BuildException {
        this.checkAttributesAllowed();
        this.defaultPatterns.setExcludesfile(excl);
        this.ds = null;
    }

    public synchronized void setDefaultexcludes(boolean useDefaultExcludes) {
        this.checkAttributesAllowed();
        this.useDefaultExcludes = useDefaultExcludes;
        this.ds = null;
    }

    public synchronized boolean getDefaultexcludes() {
        return this.isReference() ? this.getRef().getDefaultexcludes() : this.useDefaultExcludes;
    }

    public synchronized void setCaseSensitive(boolean caseSensitive) {
        this.checkAttributesAllowed();
        this.caseSensitive = caseSensitive;
        this.ds = null;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isReference() ? this.getRef().isCaseSensitive() : this.caseSensitive;
    }

    public synchronized void setFollowSymlinks(boolean followSymlinks) {
        this.checkAttributesAllowed();
        this.followSymlinks = followSymlinks;
        this.ds = null;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.isReference() ? this.getRef().isFollowSymlinks() : this.followSymlinks;
    }

    public synchronized Iterator iterator() {
        if (this.isReference()) {
            return this.getRef().iterator();
        }
        this.ensureDirectoryScannerSetup();
        this.ds.scan();
        int fct = this.ds.getIncludedFilesCount();
        int dct = this.ds.getIncludedDirsCount();
        if (fct + dct == 0) {
            return EMPTY_ITERATOR;
        }
        FileResourceIterator result = new FileResourceIterator();
        if (fct > 0) {
            result.addFiles(this.ds.getIncludedFiles());
        }
        if (dct > 0) {
            result.addFiles(this.ds.getIncludedDirectories());
        }
        return result;
    }

    public synchronized int size() {
        if (this.isReference()) {
            return this.getRef().size();
        }
        this.ensureDirectoryScannerSetup();
        this.ds.scan();
        return this.ds.getIncludedFilesCount() + this.ds.getIncludedDirsCount();
    }

    public synchronized boolean hasPatterns() {
        if (this.isReference()) {
            return this.getRef().hasPatterns();
        }
        if (this.hasPatterns(this.defaultPatterns)) {
            return true;
        }
        Iterator i2 = this.additionalPatterns.iterator();
        while (i2.hasNext()) {
            if (!this.hasPatterns((PatternSet)i2.next())) continue;
            return true;
        }
        return false;
    }

    public synchronized void appendSelector(FileSelector selector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        super.appendSelector(selector);
        this.ds = null;
    }

    public String toString() {
        if (this.isReference()) {
            return this.getRef().toString();
        }
        Iterator i2 = this.iterator();
        if (!i2.hasNext()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        while (i2.hasNext()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(i2.next());
        }
        return sb.toString();
    }

    public synchronized Object clone() {
        if (this.isReference()) {
            return this.getRef().clone();
        }
        try {
            Files f2 = (Files)super.clone();
            f2.defaultPatterns = (PatternSet)this.defaultPatterns.clone();
            f2.additionalPatterns = new Vector(this.additionalPatterns.size());
            Iterator iter = this.additionalPatterns.iterator();
            while (iter.hasNext()) {
                PatternSet ps = (PatternSet)iter.next();
                f2.additionalPatterns.add(ps.clone());
            }
            f2.selectors = new Vector(this.selectors);
            return f2;
        }
        catch (CloneNotSupportedException e2) {
            throw new BuildException(e2);
        }
    }

    public String[] mergeIncludes(Project p2) {
        return this.mergePatterns(p2).getIncludePatterns(p2);
    }

    public String[] mergeExcludes(Project p2) {
        return this.mergePatterns(p2).getExcludePatterns(p2);
    }

    public synchronized PatternSet mergePatterns(Project p2) {
        if (this.isReference()) {
            return this.getRef().mergePatterns(p2);
        }
        PatternSet ps = new PatternSet();
        ps.append(this.defaultPatterns, p2);
        int count = this.additionalPatterns.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Object o2 = this.additionalPatterns.elementAt(i2);
            ps.append((PatternSet)o2, p2);
        }
        return ps;
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    protected Files getRef() {
        return (Files)this.getCheckedRef();
    }

    private synchronized void ensureDirectoryScannerSetup() {
        if (this.ds == null) {
            this.ds = new DirectoryScanner();
            PatternSet ps = this.mergePatterns(this.getProject());
            this.ds.setIncludes(ps.getIncludePatterns(this.getProject()));
            this.ds.setExcludes(ps.getExcludePatterns(this.getProject()));
            this.ds.setSelectors(this.getSelectors(this.getProject()));
            if (this.useDefaultExcludes) {
                this.ds.addDefaultExcludes();
            }
            this.ds.setCaseSensitive(this.caseSensitive);
            this.ds.setFollowSymlinks(this.followSymlinks);
        }
    }

    private boolean hasPatterns(PatternSet ps) {
        String[] includePatterns = ps.getIncludePatterns(this.getProject());
        String[] excludePatterns = ps.getExcludePatterns(this.getProject());
        return includePatterns != null && includePatterns.length > 0 || includePatterns != null && excludePatterns.length > 0;
    }
}

