/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ImmutableResourceException;
import org.apache.tools.ant.util.PropertyOutputStream;

public class PropertyResource
extends Resource {
    private static final int PROPERTY_MAGIC = Resource.getMagicNumber("PropertyResource".getBytes());
    private static final InputStream UNSET = new InputStream(){

        public int read() {
            return -1;
        }
    };

    public PropertyResource() {
    }

    public PropertyResource(Project p2, String n2) {
        super(n2);
        this.setProject(p2);
    }

    public String getValue() {
        Project p2 = this.getProject();
        return p2 == null ? null : p2.getProperty(this.getName());
    }

    public boolean isExists() {
        return this.getValue() != null;
    }

    public long getSize() {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getSize();
        }
        return this.isExists() ? (long)this.getValue().length() : 0L;
    }

    public int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        return super.hashCode() * PROPERTY_MAGIC;
    }

    public String toString() {
        if (this.isReference()) {
            return this.getCheckedRef().toString();
        }
        return String.valueOf(this.getValue());
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        return this.isExists() ? new ByteArrayInputStream(this.getValue().getBytes()) : UNSET;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        if (this.isExists()) {
            throw new ImmutableResourceException();
        }
        return new PropertyOutputStream(this.getProject(), this.getName());
    }
}

