/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class TarResource
extends ArchiveResource {
    private String userName = "";
    private String groupName = "";
    private int uid;
    private int gid;

    public TarResource() {
    }

    public TarResource(File a2, TarEntry e2) {
        super(a2, true);
        this.setEntry(e2);
    }

    public TarResource(Resource a2, TarEntry e2) {
        super(a2, true);
        this.setEntry(e2);
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        Resource archive = this.getArchive();
        TarInputStream i2 = new TarInputStream(archive.getInputStream());
        TarEntry te = null;
        while ((te = i2.getNextEntry()) != null) {
            if (!te.getName().equals(this.getName())) continue;
            return i2;
        }
        FileUtils.close(i2);
        throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException("Use the tar task for tar output.");
    }

    public String getUserName() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getUserName();
        }
        return this.userName;
    }

    public String getGroup() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getGroup();
        }
        return this.groupName;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getUid();
        }
        return this.uid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((TarResource)this.getCheckedRef()).getGid();
        }
        return this.uid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchEntry() {
        TarInputStream i2;
        block8: {
            block7: {
                Resource archive = this.getArchive();
                i2 = null;
                try {
                    try {
                        i2 = new TarInputStream(archive.getInputStream());
                        TarEntry te = null;
                        while ((te = i2.getNextEntry()) != null) {
                            if (!te.getName().equals(this.getName())) continue;
                            this.setEntry(te);
                            Object var5_5 = null;
                            if (i2 == null) return;
                            break block7;
                        }
                        break block8;
                    }
                    catch (IOException e2) {
                        this.log(e2.getMessage(), 4);
                        throw new BuildException(e2);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (i2 != null) {
                        FileUtils.close(i2);
                    }
                    throw throwable;
                }
            }
            FileUtils.close(i2);
            return;
        }
        Object var5_6 = null;
        if (i2 != null) {
            FileUtils.close(i2);
        }
        this.setEntry(null);
    }

    private void setEntry(TarEntry e2) {
        if (e2 == null) {
            this.setExists(false);
            return;
        }
        this.setName(e2.getName());
        this.setExists(true);
        this.setLastModified(e2.getModTime().getTime());
        this.setDirectory(e2.isDirectory());
        this.setSize(e2.getSize());
        this.setMode(e2.getMode());
        this.userName = e2.getUserName();
        this.groupName = e2.getGroupName();
        this.uid = e2.getUserId();
        this.gid = e2.getGroupId();
    }
}

