/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ZipResource
extends ArchiveResource {
    private String encoding;

    public ZipResource() {
    }

    public ZipResource(File z2, String enc, ZipEntry e2) {
        super(z2, true);
        this.setEncoding(enc);
        this.setEntry(e2);
    }

    public void setZipfile(File z2) {
        this.setArchive(z2);
    }

    public File getZipfile() {
        FileResource r2 = (FileResource)this.getArchive();
        return r2.getFile();
    }

    public void addConfigured(ResourceCollection a2) {
        super.addConfigured(a2);
        if (!a2.isFilesystemOnly()) {
            throw new BuildException("only filesystem resources are supported");
        }
    }

    public void setEncoding(String enc) {
        this.checkAttributesAllowed();
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.isReference() ? ((ZipResource)this.getCheckedRef()).getEncoding() : this.encoding;
    }

    public void setRefid(Reference r2) {
        if (this.encoding != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r2);
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        final ZipFile z2 = new ZipFile(this.getZipfile(), this.getEncoding());
        ZipEntry ze = z2.getEntry(this.getName());
        if (ze == null) {
            z2.close();
            throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
        }
        return new FilterInputStream(z2.getInputStream(ze)){

            public void close() throws IOException {
                FileUtils.close(this.in);
                z2.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    this.close();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    super.finalize();
                    throw throwable;
                }
                super.finalize();
            }
        };
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException("Use the zip task for zip output.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchEntry() {
        ZipFile z2 = null;
        try {
            try {
                z2 = new ZipFile(this.getZipfile(), this.getEncoding());
                this.setEntry(z2.getEntry(this.getName()));
            }
            catch (IOException e3) {
                this.log(e3.getMessage(), 4);
                throw new BuildException(e3);
            }
            Object var4_2 = null;
            if (z2 == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (z2 == null) throw throwable;
            try {
                z2.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e2) {}
        z2.close();
        return;
    }

    private void setEntry(ZipEntry e2) {
        if (e2 == null) {
            this.setExists(false);
            return;
        }
        this.setName(e2.getName());
        this.setExists(true);
        this.setLastModified(e2.getTime());
        this.setDirectory(e2.isDirectory());
        this.setSize(e2.getSize());
        this.setMode(e2.getUnixMode());
    }
}

