/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources.selectors;

import java.util.Iterator;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Comparison;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Quantifier;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.types.resources.comparators.DelegatedResourceComparator;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;

public class Compare
extends DataType
implements ResourceSelector {
    private static final String ONE_CONTROL_MESSAGE = " the <control> element should be specified exactly once.";
    private DelegatedResourceComparator comp = new DelegatedResourceComparator();
    private Quantifier against = Quantifier.ALL;
    private Comparison when = Comparison.EQUAL;
    private Union control;

    public synchronized void add(ResourceComparator c2) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.comp.add(c2);
    }

    public synchronized void setAgainst(Quantifier against) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.against = against;
    }

    public synchronized void setWhen(Comparison when) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.when = when;
    }

    public synchronized ResourceCollection createControl() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.control != null) {
            throw this.oneControl();
        }
        this.control = new Union();
        return this.control;
    }

    public synchronized boolean isSelected(Resource r2) {
        if (this.isReference()) {
            return ((ResourceSelector)this.getCheckedRef()).isSelected(r2);
        }
        if (this.control == null) {
            throw this.oneControl();
        }
        int t2 = 0;
        int f2 = 0;
        Iterator it = this.control.iterator();
        while (it.hasNext()) {
            if (this.when.evaluate(this.comp.compare(r2, (Resource)it.next()))) {
                ++t2;
                continue;
            }
            ++f2;
        }
        return this.against.evaluate(t2, f2);
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p2) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p2);
        } else {
            if (this.control != null) {
                DataType.invokeCircularReferenceCheck(this.control, stk, p2);
            }
            DataType.invokeCircularReferenceCheck(this.comp, stk, p2);
            this.setChecked(true);
        }
    }

    private BuildException oneControl() {
        return new BuildException(super.toString() + ONE_CONTROL_MESSAGE);
    }
}

