/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources.selectors;

import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;

public class InstanceOf
implements ResourceSelector {
    private static final String ONE_ONLY = "Exactly one of class|type must be set.";
    private Project project;
    private Class clazz;
    private String type;
    private String uri;

    public void setProject(Project p2) {
        this.project = p2;
    }

    public void setClass(Class c2) {
        if (this.clazz != null) {
            throw new BuildException("The class attribute has already been set.");
        }
        this.clazz = c2;
    }

    public void setType(String s2) {
        this.type = s2;
    }

    public void setURI(String u2) {
        this.uri = u2;
    }

    public Class getCheckClass() {
        return this.clazz;
    }

    public String getType() {
        return this.type;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isSelected(Resource r2) {
        if (this.clazz == null == (this.type == null)) {
            throw new BuildException(ONE_ONLY);
        }
        Class c2 = this.clazz;
        if (this.type != null) {
            if (this.project == null) {
                throw new BuildException("No project set for InstanceOf ResourceSelector; the type attribute is invalid.");
            }
            AntTypeDefinition d2 = ComponentHelper.getComponentHelper(this.project).getDefinition(ProjectHelper.genComponentName(this.uri, this.type));
            if (d2 == null) {
                throw new BuildException("type " + this.type + " not found.");
            }
            try {
                c2 = d2.innerGetTypeClass();
            }
            catch (ClassNotFoundException e2) {
                throw new BuildException(e2);
            }
        }
        return c2.isAssignableFrom(r2.getClass());
    }
}

