/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources.selectors;

import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;

public class ResourceSelectorContainer
extends DataType {
    private Vector v = new Vector();

    public ResourceSelectorContainer() {
    }

    public ResourceSelectorContainer(ResourceSelector[] r2) {
        for (int i2 = 0; i2 < r2.length; ++i2) {
            this.add(r2[i2]);
        }
    }

    public void add(ResourceSelector s2) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (s2 == null) {
            return;
        }
        this.v.add(s2);
        this.setChecked(false);
    }

    public boolean hasSelectors() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).hasSelectors();
        }
        this.dieOnCircularReference();
        return !this.v.isEmpty();
    }

    public int selectorCount() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).selectorCount();
        }
        this.dieOnCircularReference();
        return this.v.size();
    }

    public Iterator getSelectors() {
        if (this.isReference()) {
            return ((ResourceSelectorContainer)this.getCheckedRef()).getSelectors();
        }
        this.dieOnCircularReference();
        return Collections.unmodifiableList(this.v).iterator();
    }

    protected void dieOnCircularReference(Stack stk, Project p2) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p2);
        } else {
            Iterator i2 = this.v.iterator();
            while (i2.hasNext()) {
                Object o2 = i2.next();
                if (!(o2 instanceof DataType)) continue;
                stk.push(o2);
                ResourceSelectorContainer.invokeCircularReferenceCheck((DataType)o2, stk, p2);
            }
            this.setChecked(true);
        }
    }
}

