/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.Enumeration;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.selectors.BaseSelectorContainer;
import org.apache.tools.ant.types.selectors.FileSelector;

public class SelectSelector
extends BaseSelectorContainer {
    private String ifProperty;
    private String unlessProperty;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.hasSelectors()) {
            buf.append("{select");
            if (this.ifProperty != null) {
                buf.append(" if: ");
                buf.append(this.ifProperty);
            }
            if (this.unlessProperty != null) {
                buf.append(" unless: ");
                buf.append(this.unlessProperty);
            }
            buf.append(" ");
            buf.append(super.toString());
            buf.append("}");
        }
        return buf.toString();
    }

    private SelectSelector getRef() {
        Object o2 = this.getCheckedRef(this.getClass(), "SelectSelector");
        return (SelectSelector)o2;
    }

    public boolean hasSelectors() {
        if (this.isReference()) {
            return this.getRef().hasSelectors();
        }
        return super.hasSelectors();
    }

    public int selectorCount() {
        if (this.isReference()) {
            return this.getRef().selectorCount();
        }
        return super.selectorCount();
    }

    public FileSelector[] getSelectors(Project p2) {
        if (this.isReference()) {
            return this.getRef().getSelectors(p2);
        }
        return super.getSelectors(p2);
    }

    public Enumeration selectorElements() {
        if (this.isReference()) {
            return this.getRef().selectorElements();
        }
        return super.selectorElements();
    }

    public void appendSelector(FileSelector selector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        super.appendSelector(selector);
    }

    public void verifySettings() {
        int cnt = this.selectorCount();
        if (cnt < 0 || cnt > 1) {
            this.setError("Only one selector is allowed within the <selector> tag");
        }
    }

    public boolean passesConditions() {
        if (this.ifProperty != null && this.getProject().getProperty(this.ifProperty) == null) {
            return false;
        }
        return this.unlessProperty == null || this.getProject().getProperty(this.unlessProperty) == null;
    }

    public void setIf(String ifProperty) {
        this.ifProperty = ifProperty;
    }

    public void setUnless(String unlessProperty) {
        this.unlessProperty = unlessProperty;
    }

    public boolean isSelected(File basedir, String filename, File file) {
        this.validate();
        if (!this.passesConditions()) {
            return false;
        }
        Enumeration e2 = this.selectorElements();
        if (!e2.hasMoreElements()) {
            return true;
        }
        FileSelector f2 = (FileSelector)e2.nextElement();
        return f2.isSelected(basedir, filename, file);
    }
}

