/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors.modifiedselector;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.Algorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.Cache;
import org.apache.tools.ant.types.selectors.modifiedselector.ChecksumAlgorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.DigestAlgorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.EqualComparator;
import org.apache.tools.ant.types.selectors.modifiedselector.HashvalueAlgorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.PropertiesfileCache;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ResourceUtils;

public class ModifiedSelector
extends BaseExtendSelector
implements BuildListener,
ResourceSelector {
    private static final String CACHE_START = "cache.";
    private static final String ALGORITHM_START = "algorithm.";
    private static final String COMPARATOR_START = "comparator.";
    private CacheName cacheName = null;
    private String cacheClass;
    private AlgorithmName algoName = null;
    private String algorithmClass;
    private ComparatorName compName = null;
    private String comparatorClass;
    private boolean update = true;
    private boolean selectDirectories = true;
    private boolean selectResourcesWithoutInputStream = true;
    private boolean delayUpdate = true;
    private Comparator comparator = null;
    private Algorithm algorithm = null;
    private Cache cache = null;
    private int modified = 0;
    private boolean isConfigured = false;
    private Vector configParameter = new Vector();
    private Vector specialParameter = new Vector();
    private ClassLoader myClassLoader = null;
    private Path classpath = null;
    static /* synthetic */ Class class$org$apache$tools$ant$types$selectors$modifiedselector$Algorithm;
    static /* synthetic */ Class class$org$apache$tools$ant$types$selectors$modifiedselector$Cache;
    static /* synthetic */ Class class$java$util$Comparator;

    public void verifySettings() {
        this.configure();
        if (this.cache == null) {
            this.setError("Cache must be set.");
        } else if (this.algorithm == null) {
            this.setError("Algorithm must be set.");
        } else if (!this.cache.isValid()) {
            this.setError("Cache must be proper configured.");
        } else if (!this.algorithm.isValid()) {
            this.setError("Algorithm must be proper configured.");
        }
    }

    public void configure() {
        Parameter par;
        if (this.isConfigured) {
            return;
        }
        this.isConfigured = true;
        Project p2 = this.getProject();
        String filename = "cache.properties";
        File cachefile = null;
        if (p2 != null) {
            cachefile = new File(p2.getBaseDir(), filename);
            this.getProject().addBuildListener(this);
        } else {
            cachefile = new File(filename);
            this.setDelayUpdate(false);
        }
        PropertiesfileCache defaultCache = new PropertiesfileCache(cachefile);
        DigestAlgorithm defaultAlgorithm = new DigestAlgorithm();
        EqualComparator defaultComparator = new EqualComparator();
        this.update = true;
        this.selectDirectories = true;
        Iterator itConfig = this.configParameter.iterator();
        while (itConfig.hasNext()) {
            par = (Parameter)itConfig.next();
            if (par.getName().indexOf(".") > 0) {
                this.specialParameter.add(par);
                continue;
            }
            this.useParameter(par);
        }
        this.configParameter = new Vector();
        if (this.algoName != null) {
            if ("hashvalue".equals(this.algoName.getValue())) {
                this.algorithm = new HashvalueAlgorithm();
            } else if ("digest".equals(this.algoName.getValue())) {
                this.algorithm = new DigestAlgorithm();
            } else if ("checksum".equals(this.algoName.getValue())) {
                this.algorithm = new ChecksumAlgorithm();
            }
        } else {
            this.algorithm = this.algorithmClass != null ? (Algorithm)this.loadClass(this.algorithmClass, "is not an Algorithm.", class$org$apache$tools$ant$types$selectors$modifiedselector$Algorithm == null ? (class$org$apache$tools$ant$types$selectors$modifiedselector$Algorithm = ModifiedSelector.class$("org.apache.tools.ant.types.selectors.modifiedselector.Algorithm")) : class$org$apache$tools$ant$types$selectors$modifiedselector$Algorithm) : defaultAlgorithm;
        }
        if (this.cacheName != null) {
            if ("propertyfile".equals(this.cacheName.getValue())) {
                this.cache = new PropertiesfileCache();
            }
        } else {
            this.cache = this.cacheClass != null ? (Cache)this.loadClass(this.cacheClass, "is not a Cache.", class$org$apache$tools$ant$types$selectors$modifiedselector$Cache == null ? (class$org$apache$tools$ant$types$selectors$modifiedselector$Cache = ModifiedSelector.class$("org.apache.tools.ant.types.selectors.modifiedselector.Cache")) : class$org$apache$tools$ant$types$selectors$modifiedselector$Cache) : defaultCache;
        }
        if (this.compName != null) {
            if ("equal".equals(this.compName.getValue())) {
                this.comparator = new EqualComparator();
            } else if ("rule".equals(this.compName.getValue())) {
                throw new BuildException("RuleBasedCollator not yet supported.");
            }
        } else {
            this.comparator = this.comparatorClass != null ? (Comparator)this.loadClass(this.comparatorClass, "is not a Comparator.", class$java$util$Comparator == null ? (class$java$util$Comparator = ModifiedSelector.class$("java.util.Comparator")) : class$java$util$Comparator) : defaultComparator;
        }
        Iterator itSpecial = this.specialParameter.iterator();
        while (itSpecial.hasNext()) {
            par = (Parameter)itSpecial.next();
            this.useParameter(par);
        }
        this.specialParameter = new Vector();
    }

    protected Object loadClass(String classname, String msg, Class type) {
        try {
            ClassLoader cl2 = this.getClassLoader();
            Class<?> clazz = null;
            clazz = cl2 != null ? cl2.loadClass(classname) : Class.forName(classname);
            Object rv = clazz.newInstance();
            if (!type.isInstance(rv)) {
                throw new BuildException("Specified class (" + classname + ") " + msg);
            }
            return rv;
        }
        catch (ClassNotFoundException e2) {
            throw new BuildException("Specified class (" + classname + ") not found.");
        }
        catch (Exception e3) {
            throw new BuildException(e3);
        }
    }

    public boolean isSelected(Resource resource) {
        if (resource.isFilesystemOnly()) {
            FileResource fileResource = (FileResource)resource;
            File file = fileResource.getFile();
            String filename = fileResource.getName();
            File basedir = fileResource.getBaseDir();
            return this.isSelected(basedir, filename, file);
        }
        try {
            FileUtils fu2 = FileUtils.getFileUtils();
            File tmpFile = fu2.createTempFile("modified-", ".tmp", null, true, true);
            FileResource tmpResource = new FileResource(tmpFile);
            ResourceUtils.copyResource(resource, tmpResource);
            boolean isSelected = this.isSelected(tmpFile.getParentFile(), tmpFile.getName(), resource.toLongString());
            return isSelected;
        }
        catch (UnsupportedOperationException uoe) {
            this.log("The resource '" + resource.getName() + "' does not provide an InputStream, so it is not checked. " + "Akkording to 'selres' attribute value it is " + (this.selectResourcesWithoutInputStream ? "" : " not") + "selected.", 2);
            return this.selectResourcesWithoutInputStream;
        }
        catch (Exception e2) {
            throw new BuildException(e2);
        }
    }

    public boolean isSelected(File basedir, String filename, File file) {
        return this.isSelected(basedir, filename, file.getAbsolutePath());
    }

    private boolean isSelected(File basedir, String filename, String cacheKey) {
        String newValue;
        boolean rv;
        this.validate();
        File f2 = new File(basedir, filename);
        if (f2.isDirectory()) {
            return this.selectDirectories;
        }
        String cachedValue = String.valueOf(this.cache.get(f2.getAbsolutePath()));
        boolean bl2 = rv = this.comparator.compare(cachedValue, newValue = this.algorithm.getValue(f2)) != 0;
        if (this.update && rv) {
            this.cache.put(f2.getAbsolutePath(), newValue);
            this.setModified(this.getModified() + 1);
            if (!this.getDelayUpdate()) {
                this.saveCache();
            }
        }
        return rv;
    }

    protected void saveCache() {
        if (this.getModified() > 0) {
            this.cache.save();
            this.setModified(0);
        }
    }

    public void setAlgorithmClass(String classname) {
        this.algorithmClass = classname;
    }

    public void setComparatorClass(String classname) {
        this.comparatorClass = classname;
    }

    public void setCacheClass(String classname) {
        this.cacheClass = classname;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setSeldirs(boolean seldirs) {
        this.selectDirectories = seldirs;
    }

    public void setSelres(boolean newValue) {
        this.selectResourcesWithoutInputStream = newValue;
    }

    public int getModified() {
        return this.modified;
    }

    public void setModified(int modified) {
        this.modified = modified;
    }

    public boolean getDelayUpdate() {
        return this.delayUpdate;
    }

    public void setDelayUpdate(boolean delayUpdate) {
        this.delayUpdate = delayUpdate;
    }

    public void addClasspath(Path path) {
        if (this.classpath != null) {
            throw new BuildException("<classpath> can be set only once.");
        }
        this.classpath = path;
    }

    public ClassLoader getClassLoader() {
        if (this.myClassLoader == null) {
            this.myClassLoader = this.classpath == null ? this.getClass().getClassLoader() : this.getProject().createClassLoader(this.classpath);
        }
        return this.myClassLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.myClassLoader = loader;
    }

    public void addParam(String key, Object value) {
        Parameter par = new Parameter();
        par.setName(key);
        par.setValue(String.valueOf(value));
        this.configParameter.add(par);
    }

    public void addParam(Parameter parameter) {
        this.configParameter.add(parameter);
    }

    public void setParameters(Parameter[] parameters) {
        if (parameters != null) {
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                this.configParameter.add(parameters[i2]);
            }
        }
    }

    public void useParameter(Parameter parameter) {
        String key = parameter.getName();
        String value = parameter.getValue();
        if ("cache".equals(key)) {
            CacheName cn2 = new CacheName();
            cn2.setValue(value);
            this.setCache(cn2);
        } else if ("algorithm".equals(key)) {
            AlgorithmName an2 = new AlgorithmName();
            an2.setValue(value);
            this.setAlgorithm(an2);
        } else if ("comparator".equals(key)) {
            ComparatorName cn3 = new ComparatorName();
            cn3.setValue(value);
            this.setComparator(cn3);
        } else if ("update".equals(key)) {
            boolean updateValue = "true".equalsIgnoreCase(value);
            this.setUpdate(updateValue);
        } else if ("delayupdate".equals(key)) {
            boolean updateValue = "true".equalsIgnoreCase(value);
            this.setDelayUpdate(updateValue);
        } else if ("seldirs".equals(key)) {
            boolean sdValue = "true".equalsIgnoreCase(value);
            this.setSeldirs(sdValue);
        } else if (key.startsWith(CACHE_START)) {
            String name = key.substring(CACHE_START.length());
            this.tryToSetAParameter(this.cache, name, value);
        } else if (key.startsWith(ALGORITHM_START)) {
            String name = key.substring(ALGORITHM_START.length());
            this.tryToSetAParameter(this.algorithm, name, value);
        } else if (key.startsWith(COMPARATOR_START)) {
            String name = key.substring(COMPARATOR_START.length());
            this.tryToSetAParameter(this.comparator, name, value);
        } else {
            this.setError("Invalid parameter " + key);
        }
    }

    protected void tryToSetAParameter(Object obj, String name, String value) {
        Project prj = this.getProject() != null ? this.getProject() : new Project();
        IntrospectionHelper iHelper = IntrospectionHelper.getHelper(prj, obj.getClass());
        try {
            iHelper.setAttribute(prj, obj, name, value);
        }
        catch (BuildException e2) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{modifiedselector");
        buf.append(" update=").append(this.update);
        buf.append(" seldirs=").append(this.selectDirectories);
        buf.append(" cache=").append(this.cache);
        buf.append(" algorithm=").append(this.algorithm);
        buf.append(" comparator=").append(this.comparator);
        buf.append("}");
        return buf.toString();
    }

    public void buildFinished(BuildEvent event) {
        if (this.getDelayUpdate()) {
            this.saveCache();
        }
    }

    public void targetFinished(BuildEvent event) {
        if (this.getDelayUpdate()) {
            this.saveCache();
        }
    }

    public void taskFinished(BuildEvent event) {
        if (this.getDelayUpdate()) {
            this.saveCache();
        }
    }

    public void buildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(CacheName name) {
        this.cacheName = name;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmName name) {
        this.algoName = name;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(ComparatorName name) {
        this.compName = name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ComparatorName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"equal", "rule"};
        }
    }

    public static class AlgorithmName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"hashvalue", "digest", "checksum"};
        }
    }

    public static class CacheName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"propertyfile"};
        }
    }
}

