/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ClasspathUtils {
    public static final String REUSE_LOADER_REF = "ant.reuse.loader";
    static /* synthetic */ Class class$java$lang$Object;

    public static ClassLoader getClassLoaderForPath(Project p2, Reference ref) {
        return ClasspathUtils.getClassLoaderForPath(p2, ref, false);
    }

    public static ClassLoader getClassLoaderForPath(Project p2, Reference ref, boolean reverseLoader) {
        String pathId = ref.getRefId();
        Object path = p2.getReference(pathId);
        if (!(path instanceof Path)) {
            throw new BuildException("The specified classpathref " + pathId + " does not reference a Path.");
        }
        String loaderId = "ant.loader." + pathId;
        return ClasspathUtils.getClassLoaderForPath(p2, (Path)path, loaderId, reverseLoader);
    }

    public static ClassLoader getClassLoaderForPath(Project p2, Path path, String loaderId) {
        return ClasspathUtils.getClassLoaderForPath(p2, path, loaderId, false);
    }

    public static ClassLoader getClassLoaderForPath(Project p2, Path path, String loaderId, boolean reverseLoader) {
        return ClasspathUtils.getClassLoaderForPath(p2, path, loaderId, reverseLoader, ClasspathUtils.isMagicPropertySet(p2));
    }

    public static ClassLoader getClassLoaderForPath(Project p2, Path path, String loaderId, boolean reverseLoader, boolean reuseLoader) {
        ClassLoader cl2 = null;
        if (loaderId != null && reuseLoader) {
            Object reusedLoader = p2.getReference(loaderId);
            if (reusedLoader != null && !(reusedLoader instanceof ClassLoader)) {
                throw new BuildException("The specified loader id " + loaderId + " does not reference a class loader");
            }
            cl2 = (ClassLoader)reusedLoader;
        }
        if (cl2 == null) {
            cl2 = ClasspathUtils.getUniqueClassLoaderForPath(p2, path, reverseLoader);
            if (loaderId != null && reuseLoader) {
                p2.addReference(loaderId, cl2);
            }
        }
        return cl2;
    }

    public static ClassLoader getUniqueClassLoaderForPath(Project p2, Path path, boolean reverseLoader) {
        AntClassLoader acl = p2.createClassLoader(path);
        if (reverseLoader) {
            acl.setParentFirst(false);
            acl.addJavaLibraries();
        }
        return acl;
    }

    public static Object newInstance(String className, ClassLoader userDefinedLoader) {
        return ClasspathUtils.newInstance(className, userDefinedLoader, class$java$lang$Object == null ? (class$java$lang$Object = ClasspathUtils.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public static Object newInstance(String className, ClassLoader userDefinedLoader, Class expectedType) {
        try {
            Class<?> clazz = Class.forName(className, true, userDefinedLoader);
            Object o2 = clazz.newInstance();
            if (!expectedType.isInstance(o2)) {
                throw new BuildException("Class of unexpected Type: " + className + " expected :" + expectedType);
            }
            return o2;
        }
        catch (ClassNotFoundException e2) {
            throw new BuildException("Class not found: " + className, e2);
        }
        catch (InstantiationException e3) {
            throw new BuildException("Could not instantiate " + className + ". Specified class should have a no " + "argument constructor.", e3);
        }
        catch (IllegalAccessException e4) {
            throw new BuildException("Could not instantiate " + className + ". Specified class should have a " + "public constructor.", e4);
        }
        catch (LinkageError e5) {
            throw new BuildException("Class " + className + " could not be loaded because of an invalid dependency.", e5);
        }
    }

    public static Delegate getDelegate(ProjectComponent component) {
        return new Delegate(component);
    }

    private static boolean isMagicPropertySet(Project p2) {
        return p2.getProperty(REUSE_LOADER_REF) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Delegate {
        private final ProjectComponent component;
        private Path classpath;
        private String classpathId;
        private String className;
        private String loaderId;
        private boolean reverseLoader = false;

        Delegate(ProjectComponent component) {
            this.component = component;
        }

        public void setClasspath(Path classpath) {
            if (this.classpath == null) {
                this.classpath = classpath;
            } else {
                this.classpath.append(classpath);
            }
        }

        public Path createClasspath() {
            if (this.classpath == null) {
                this.classpath = new Path(this.component.getProject());
            }
            return this.classpath.createPath();
        }

        public void setClassname(String fcqn) {
            this.className = fcqn;
        }

        public void setClasspathref(Reference r2) {
            this.classpathId = r2.getRefId();
            this.createClasspath().setRefid(r2);
        }

        public void setReverseLoader(boolean reverseLoader) {
            this.reverseLoader = reverseLoader;
        }

        public void setLoaderRef(Reference r2) {
            this.loaderId = r2.getRefId();
        }

        public ClassLoader getClassLoader() {
            return ClasspathUtils.getClassLoaderForPath(this.getContextProject(), this.classpath, this.getClassLoadId(), this.reverseLoader, this.loaderId != null || ClasspathUtils.isMagicPropertySet(this.getContextProject()));
        }

        private Project getContextProject() {
            return this.component.getProject();
        }

        public String getClassLoadId() {
            return this.loaderId == null && this.classpathId != null ? "ant.loader." + this.classpathId : this.loaderId;
        }

        public Object newInstance() {
            return ClasspathUtils.newInstance(this.className, this.getClassLoader());
        }

        public Path getClasspath() {
            return this.classpath;
        }

        public boolean isReverseLoader() {
            return this.reverseLoader;
        }
    }
}

