/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMElementWriter {
    private static final int HEX = 16;
    private static final String NS = "ns";
    private boolean xmlDeclaration = true;
    private XmlNamespacePolicy namespacePolicy = XmlNamespacePolicy.IGNORE;
    private HashMap nsPrefixMap = new HashMap();
    private int nextPrefix = 0;
    private HashMap nsURIByElement = new HashMap();
    private static String lSep = System.getProperty("line.separator");
    protected String[] knownEntities = new String[]{"gt", "amp", "lt", "apos", "quot"};

    public DOMElementWriter() {
    }

    public DOMElementWriter(boolean xmlDeclaration) {
        this(xmlDeclaration, XmlNamespacePolicy.IGNORE);
    }

    public DOMElementWriter(boolean xmlDeclaration, XmlNamespacePolicy namespacePolicy) {
        this.xmlDeclaration = xmlDeclaration;
        this.namespacePolicy = namespacePolicy;
    }

    public void write(Element root, OutputStream out) throws IOException {
        OutputStreamWriter wri = new OutputStreamWriter(out, "UTF8");
        this.writeXMLDeclaration(wri);
        this.write(root, wri, 0, "  ");
        ((Writer)wri).flush();
    }

    public void writeXMLDeclaration(Writer wri) throws IOException {
        if (this.xmlDeclaration) {
            wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
    }

    public void write(Element element, Writer out, int indent, String indentWith) throws IOException {
        NodeList children = element.getChildNodes();
        boolean hasChildren = children.getLength() > 0;
        boolean hasChildElements = false;
        this.openElement(element, out, indent, indentWith, hasChildren);
        if (hasChildren) {
            block8: for (int i2 = 0; i2 < children.getLength(); ++i2) {
                Node child = children.item(i2);
                switch (child.getNodeType()) {
                    case 1: {
                        hasChildElements = true;
                        if (i2 == 0) {
                            out.write(lSep);
                        }
                        this.write((Element)child, out, indent + 1, indentWith);
                        continue block8;
                    }
                    case 3: {
                        out.write(this.encode(child.getNodeValue()));
                        continue block8;
                    }
                    case 8: {
                        out.write("<!--");
                        out.write(this.encode(child.getNodeValue()));
                        out.write("-->");
                        continue block8;
                    }
                    case 4: {
                        out.write("<![CDATA[");
                        out.write(this.encodedata(((Text)child).getData()));
                        out.write("]]>");
                        continue block8;
                    }
                    case 5: {
                        out.write(38);
                        out.write(child.getNodeName());
                        out.write(59);
                        continue block8;
                    }
                    case 7: {
                        out.write("<?");
                        out.write(child.getNodeName());
                        String data = child.getNodeValue();
                        if (data != null && data.length() > 0) {
                            out.write(32);
                            out.write(data);
                        }
                        out.write("?>");
                        continue block8;
                    }
                }
            }
            this.closeElement(element, out, indent, indentWith, hasChildElements);
        }
    }

    public void openElement(Element element, Writer out, int indent, String indentWith) throws IOException {
        this.openElement(element, out, indent, indentWith, true);
    }

    public void openElement(Element element, Writer out, int indent, String indentWith, boolean hasChildren) throws IOException {
        String prefix;
        String uri;
        for (int i2 = 0; i2 < indent; ++i2) {
            out.write(indentWith);
        }
        out.write("<");
        if (this.namespacePolicy.qualifyElements) {
            String uri2 = DOMElementWriter.getNamespaceURI(element);
            String prefix2 = (String)this.nsPrefixMap.get(uri2);
            if (prefix2 == null) {
                prefix2 = this.nsPrefixMap.isEmpty() ? "" : NS + this.nextPrefix++;
                this.nsPrefixMap.put(uri2, prefix2);
                this.addNSDefinition(element, uri2);
            }
            if (!"".equals(prefix2)) {
                out.write(prefix2);
                out.write(":");
            }
        }
        out.write(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        for (int i3 = 0; i3 < attrs.getLength(); ++i3) {
            Attr attr = (Attr)attrs.item(i3);
            out.write(" ");
            if (this.namespacePolicy.qualifyAttributes) {
                uri = DOMElementWriter.getNamespaceURI(attr);
                prefix = (String)this.nsPrefixMap.get(uri);
                if (prefix == null) {
                    prefix = NS + this.nextPrefix++;
                    this.nsPrefixMap.put(uri, prefix);
                    this.addNSDefinition(element, uri);
                }
                out.write(prefix);
                out.write(":");
            }
            out.write(attr.getName());
            out.write("=\"");
            out.write(this.encode(attr.getValue()));
            out.write("\"");
        }
        ArrayList al2 = (ArrayList)this.nsURIByElement.get(element);
        if (al2 != null) {
            Iterator iter = al2.iterator();
            while (iter.hasNext()) {
                uri = (String)iter.next();
                prefix = (String)this.nsPrefixMap.get(uri);
                out.write(" xmlns");
                if (!"".equals(prefix)) {
                    out.write(":");
                    out.write(prefix);
                }
                out.write("=\"");
                out.write(uri);
                out.write("\"");
            }
        }
        if (hasChildren) {
            out.write(">");
        } else {
            this.removeNSDefinitions(element);
            out.write(" />");
            out.write(lSep);
            out.flush();
        }
    }

    public void closeElement(Element element, Writer out, int indent, String indentWith, boolean hasChildren) throws IOException {
        if (hasChildren) {
            for (int i2 = 0; i2 < indent; ++i2) {
                out.write(indentWith);
            }
        }
        out.write("</");
        if (this.namespacePolicy.qualifyElements) {
            String uri = DOMElementWriter.getNamespaceURI(element);
            String prefix = (String)this.nsPrefixMap.get(uri);
            if (prefix != null && !"".equals(prefix)) {
                out.write(prefix);
                out.write(":");
            }
            this.removeNSDefinitions(element);
        }
        out.write(element.getTagName());
        out.write(">");
        out.write(lSep);
        out.flush();
    }

    public String encode(String value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        block7: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = value.charAt(i2);
            switch (c2) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    int nextSemi = value.indexOf(";", i2);
                    if (nextSemi < 0 || !this.isReference(value.substring(i2, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block7;
                    }
                    sb.append('&');
                    continue block7;
                }
                default: {
                    if (!this.isLegalCharacter(c2)) continue block7;
                    sb.append(c2);
                }
            }
        }
        return sb.substring(0);
    }

    public String encodedata(String value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = value.charAt(i2);
            if (!this.isLegalCharacter(c2)) continue;
            sb.append(c2);
        }
        String result = sb.substring(0);
        int cdEnd = result.indexOf("]]>");
        while (cdEnd != -1) {
            sb.setLength(cdEnd);
            sb.append("&#x5d;&#x5d;&gt;").append(result.substring(cdEnd + 3));
            result = sb.substring(0);
            cdEnd = result.indexOf("]]>");
        }
        return result;
    }

    public boolean isReference(String ent) {
        if (ent.charAt(0) != '&' || !ent.endsWith(";")) {
            return false;
        }
        if (ent.charAt(1) == '#') {
            if (ent.charAt(2) == 'x') {
                try {
                    Integer.parseInt(ent.substring(3, ent.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            try {
                Integer.parseInt(ent.substring(2, ent.length() - 1));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = ent.substring(1, ent.length() - 1);
        for (int i2 = 0; i2 < this.knownEntities.length; ++i2) {
            if (!name.equals(this.knownEntities[i2])) continue;
            return true;
        }
        return false;
    }

    public boolean isLegalCharacter(char c2) {
        if (c2 == '\t' || c2 == '\n' || c2 == '\r') {
            return true;
        }
        if (c2 < ' ') {
            return false;
        }
        if (c2 <= '\ud7ff') {
            return true;
        }
        if (c2 < '\ue000') {
            return false;
        }
        return c2 <= '\ufffd';
    }

    private void removeNSDefinitions(Element element) {
        ArrayList al2 = (ArrayList)this.nsURIByElement.get(element);
        if (al2 != null) {
            Iterator iter = al2.iterator();
            while (iter.hasNext()) {
                this.nsPrefixMap.remove(iter.next());
            }
            this.nsURIByElement.remove(element);
        }
    }

    private void addNSDefinition(Element element, String uri) {
        ArrayList<String> al2 = (ArrayList<String>)this.nsURIByElement.get(element);
        if (al2 == null) {
            al2 = new ArrayList<String>();
            this.nsURIByElement.put(element, al2);
        }
        al2.add(uri);
    }

    private static String getNamespaceURI(Node n2) {
        String uri = n2.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        return uri;
    }

    public static class XmlNamespacePolicy {
        private boolean qualifyElements;
        private boolean qualifyAttributes;
        public static final XmlNamespacePolicy IGNORE = new XmlNamespacePolicy(false, false);
        public static final XmlNamespacePolicy ONLY_QUALIFY_ELEMENTS = new XmlNamespacePolicy(true, false);
        public static final XmlNamespacePolicy QUALIFY_ALL = new XmlNamespacePolicy(true, true);

        public XmlNamespacePolicy(boolean qualifyElements, boolean qualifyAttributes) {
            this.qualifyElements = qualifyElements;
            this.qualifyAttributes = qualifyAttributes;
        }
    }
}

