/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.StringTokenizer;

public class DeweyDecimal {
    private int[] components;

    public DeweyDecimal(int[] components) {
        this.components = new int[components.length];
        System.arraycopy(components, 0, this.components, 0, components.length);
    }

    public DeweyDecimal(String string) throws NumberFormatException {
        StringTokenizer tokenizer = new StringTokenizer(string, ".", true);
        int size = tokenizer.countTokens();
        this.components = new int[(size + 1) / 2];
        for (int i2 = 0; i2 < this.components.length; ++i2) {
            String component = tokenizer.nextToken();
            if (component.equals("")) {
                throw new NumberFormatException("Empty component in string");
            }
            this.components[i2] = Integer.parseInt(component);
            if (!tokenizer.hasMoreTokens()) continue;
            tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) continue;
            throw new NumberFormatException("DeweyDecimal ended in a '.'");
        }
    }

    public int getSize() {
        return this.components.length;
    }

    public int get(int index) {
        return this.components[index];
    }

    public boolean isEqual(DeweyDecimal other) {
        int max = Math.max(other.components.length, this.components.length);
        for (int i2 = 0; i2 < max; ++i2) {
            int component2;
            int component1 = i2 < this.components.length ? this.components[i2] : 0;
            int n2 = component2 = i2 < other.components.length ? other.components[i2] : 0;
            if (component2 == component1) continue;
            return false;
        }
        return true;
    }

    public boolean isLessThan(DeweyDecimal other) {
        return !this.isGreaterThanOrEqual(other);
    }

    public boolean isLessThanOrEqual(DeweyDecimal other) {
        return !this.isGreaterThan(other);
    }

    public boolean isGreaterThan(DeweyDecimal other) {
        int max = Math.max(other.components.length, this.components.length);
        for (int i2 = 0; i2 < max; ++i2) {
            int component2;
            int component1 = i2 < this.components.length ? this.components[i2] : 0;
            int n2 = component2 = i2 < other.components.length ? other.components[i2] : 0;
            if (component2 > component1) {
                return false;
            }
            if (component2 >= component1) continue;
            return true;
        }
        return false;
    }

    public boolean isGreaterThanOrEqual(DeweyDecimal other) {
        int max = Math.max(other.components.length, this.components.length);
        for (int i2 = 0; i2 < max; ++i2) {
            int component2;
            int component1 = i2 < this.components.length ? this.components[i2] : 0;
            int n2 = component2 = i2 < other.components.length ? other.components[i2] : 0;
            if (component2 > component1) {
                return false;
            }
            if (component2 >= component1) continue;
            return true;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.components.length; ++i2) {
            if (i2 != 0) {
                sb.append('.');
            }
            sb.append(this.components[i2]);
        }
        return sb.toString();
    }
}

