/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LineOrientedOutputStream
extends OutputStream {
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(132);
    private boolean skip = false;

    public final void write(int cc2) throws IOException {
        byte c2 = (byte)cc2;
        if (c2 == 10 || c2 == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            this.buffer.write(cc2);
        }
        this.skip = c2 == 13;
    }

    public final void flush() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBuffer() throws IOException {
        try {
            this.processLine(this.buffer.toString());
        }
        finally {
            this.buffer.reset();
        }
    }

    protected abstract void processLine(String var1) throws IOException;

    public final void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
        super.close();
    }

    public final void write(byte[] b2, int off, int len) throws IOException {
        int offset;
        int blockStartOffset = offset = off;
        int remaining = len;
        while (remaining > 0) {
            while (remaining > 0 && b2[offset] != 10 && b2[offset] != 13) {
                ++offset;
                --remaining;
            }
            int blockLength = offset - blockStartOffset;
            if (blockLength > 0) {
                this.buffer.write(b2, blockStartOffset, blockLength);
            }
            while (remaining > 0 && (b2[offset] == 10 || b2[offset] == 13)) {
                this.write(b2[offset]);
                ++offset;
                --remaining;
            }
            blockStartOffset = offset;
        }
    }
}

