/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.util.Tokenizer;

public class LineTokenizer
extends ProjectComponent
implements Tokenizer {
    private static final int NOT_A_CHAR = -2;
    private String lineEnd = "";
    private int pushed = -2;
    private boolean includeDelims = false;

    public void setIncludeDelims(boolean includeDelims) {
        this.includeDelims = includeDelims;
    }

    public String getToken(Reader in) throws IOException {
        int ch2 = -1;
        if (this.pushed != -2) {
            ch2 = this.pushed;
            this.pushed = -2;
        } else {
            ch2 = in.read();
        }
        if (ch2 == -1) {
            return null;
        }
        this.lineEnd = "";
        StringBuffer line = new StringBuffer();
        boolean state = false;
        while (ch2 != -1) {
            if (!state) {
                if (ch2 == 13) {
                    state = true;
                } else {
                    if (ch2 == 10) {
                        this.lineEnd = "\n";
                        break;
                    }
                    line.append((char)ch2);
                }
            } else {
                state = false;
                if (ch2 == 10) {
                    this.lineEnd = "\r\n";
                    break;
                }
                this.pushed = ch2;
                this.lineEnd = "\r";
                break;
            }
            ch2 = in.read();
        }
        if (ch2 == -1 && state) {
            this.lineEnd = "\r";
        }
        if (this.includeDelims) {
            line.append(this.lineEnd);
        }
        return line.toString();
    }

    public String getPostToken() {
        if (this.includeDelims) {
            return "";
        }
        return this.lineEnd;
    }
}

