/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.util.FileUtils;

public class LoaderUtils {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    static /* synthetic */ Class class$org$apache$tools$ant$util$LoaderUtils;

    public static void setContextClassLoader(ClassLoader loader) {
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(loader);
    }

    public static ClassLoader getContextClassLoader() {
        Thread currentThread = Thread.currentThread();
        return currentThread.getContextClassLoader();
    }

    public static boolean isContextLoaderAvailable() {
        return true;
    }

    private static File normalizeSource(File source) {
        if (source != null) {
            try {
                source = FILE_UTILS.normalize(source.getAbsolutePath());
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
        return source;
    }

    public static File getClassSource(Class c2) {
        return LoaderUtils.normalizeSource(Locator.getClassSource(c2));
    }

    public static File getResourceSource(ClassLoader c2, String resource) {
        if (c2 == null) {
            c2 = (class$org$apache$tools$ant$util$LoaderUtils == null ? (class$org$apache$tools$ant$util$LoaderUtils = LoaderUtils.class$("org.apache.tools.ant.util.LoaderUtils")) : class$org$apache$tools$ant$util$LoaderUtils).getClassLoader();
        }
        return LoaderUtils.normalizeSource(Locator.getResourceSource(c2, resource));
    }

    public static String classNameToResource(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static boolean classExists(ClassLoader loader, String className) {
        return loader.getResource(LoaderUtils.classNameToResource(className)) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

