/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ResourceUtils;

public class SourceFileScanner
implements ResourceFactory {
    protected Task task;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File destDir;

    public SourceFileScanner(Task task) {
        this.task = task;
    }

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper) {
        return this.restrict(files, srcDir, destDir, mapper, FILE_UTILS.getFileTimestampGranularity());
    }

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper, long granularity) {
        this.destDir = destDir;
        Vector<1> v2 = new Vector<1>();
        for (int i2 = 0; i2 < files.length; ++i2) {
            final String name = files[i2];
            v2.addElement(new FileResource(srcDir, name){

                public String getName() {
                    return name;
                }
            });
        }
        Object[] sourceresources = new Resource[v2.size()];
        v2.copyInto(sourceresources);
        Resource[] outofdate = ResourceUtils.selectOutOfDateSources((ProjectComponent)this.task, (Resource[])sourceresources, mapper, (ResourceFactory)this, granularity);
        String[] result = new String[outofdate.length];
        for (int counter = 0; counter < outofdate.length; ++counter) {
            result[counter] = outofdate[counter].getName();
        }
        return result;
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper) {
        return this.restrictAsFiles(files, srcDir, destDir, mapper, FILE_UTILS.getFileTimestampGranularity());
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper, long granularity) {
        String[] res = this.restrict(files, srcDir, destDir, mapper, granularity);
        File[] result = new File[res.length];
        for (int i2 = 0; i2 < res.length; ++i2) {
            result[i2] = new File(srcDir, res[i2]);
        }
        return result;
    }

    public Resource getResource(String name) {
        return new FileResource(this.destDir, name);
    }
}

