/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.Tokenizer;

public class StringTokenizer
extends ProjectComponent
implements Tokenizer {
    private static final int NOT_A_CHAR = -2;
    private String intraString = "";
    private int pushed = -2;
    private char[] delims = null;
    private boolean delimsAreTokens = false;
    private boolean suppressDelims = false;
    private boolean includeDelims = false;

    public void setDelims(String delims) {
        this.delims = StringUtils.resolveBackSlash(delims).toCharArray();
    }

    public void setDelimsAreTokens(boolean delimsAreTokens) {
        this.delimsAreTokens = delimsAreTokens;
    }

    public void setSuppressDelims(boolean suppressDelims) {
        this.suppressDelims = suppressDelims;
    }

    public void setIncludeDelims(boolean includeDelims) {
        this.includeDelims = includeDelims;
    }

    public String getToken(Reader in) throws IOException {
        int ch2 = -1;
        if (this.pushed != -2) {
            ch2 = this.pushed;
            this.pushed = -2;
        } else {
            ch2 = in.read();
        }
        if (ch2 == -1) {
            return null;
        }
        boolean inToken = true;
        this.intraString = "";
        StringBuffer word = new StringBuffer();
        StringBuffer padding = new StringBuffer();
        while (ch2 != -1) {
            char c2 = (char)ch2;
            boolean isDelim = this.isDelim(c2);
            if (inToken) {
                if (isDelim) {
                    if (this.delimsAreTokens) {
                        if (word.length() == 0) {
                            word.append(c2);
                            break;
                        }
                        this.pushed = ch2;
                        break;
                    }
                    padding.append(c2);
                    inToken = false;
                } else {
                    word.append(c2);
                }
            } else if (isDelim) {
                padding.append(c2);
            } else {
                this.pushed = ch2;
                break;
            }
            ch2 = in.read();
        }
        this.intraString = padding.toString();
        if (this.includeDelims) {
            word.append(this.intraString);
        }
        return word.toString();
    }

    public String getPostToken() {
        return this.suppressDelims || this.includeDelims ? "" : this.intraString;
    }

    private boolean isDelim(char ch2) {
        if (this.delims == null) {
            return Character.isWhitespace(ch2);
        }
        for (int i2 = 0; i2 < this.delims.length; ++i2) {
            if (this.delims[i2] != ch2) continue;
            return true;
        }
        return false;
    }
}

