/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

public final class StringUtils {
    private static final long KILOBYTE = 1024L;
    private static final long MEGABYTE = 0x100000L;
    private static final long GIGABYTE = 0x40000000L;
    private static final long TERABYTE = 0x10000000000L;
    private static final long PETABYTE = 0x4000000000000L;
    public static final String LINE_SEP = System.getProperty("line.separator");

    private StringUtils() {
    }

    public static Vector lineSplit(String data) {
        return StringUtils.split(data, 10);
    }

    public static Vector split(String data, int ch2) {
        Vector<String> elems = new Vector<String>();
        int pos = -1;
        int i2 = 0;
        while ((pos = data.indexOf(ch2, i2)) != -1) {
            String elem = data.substring(i2, pos);
            elems.addElement(elem);
            i2 = pos + 1;
        }
        elems.addElement(data.substring(i2));
        return elems;
    }

    public static String replace(String data, String from, String to) {
        StringBuffer buf = new StringBuffer(data.length());
        int pos = -1;
        int i2 = 0;
        while ((pos = data.indexOf(from, i2)) != -1) {
            buf.append(data.substring(i2, pos)).append(to);
            i2 = pos + from.length();
        }
        buf.append(data.substring(i2));
        return buf.toString();
    }

    public static String getStackTrace(Throwable t2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t2.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    public static boolean endsWith(StringBuffer buffer, String suffix) {
        if (suffix.length() > buffer.length()) {
            return false;
        }
        int bufferIndex = buffer.length() - 1;
        for (int endIndex = suffix.length() - 1; endIndex >= 0; --endIndex) {
            if (buffer.charAt(bufferIndex) != suffix.charAt(endIndex)) {
                return false;
            }
            --bufferIndex;
        }
        return true;
    }

    public static String resolveBackSlash(String input) {
        StringBuffer b2 = new StringBuffer();
        boolean backSlashSeen = false;
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (!backSlashSeen) {
                if (c2 == '\\') {
                    backSlashSeen = true;
                    continue;
                }
                b2.append(c2);
                continue;
            }
            switch (c2) {
                case '\\': {
                    b2.append('\\');
                    break;
                }
                case 'n': {
                    b2.append('\n');
                    break;
                }
                case 'r': {
                    b2.append('\r');
                    break;
                }
                case 't': {
                    b2.append('\t');
                    break;
                }
                case 'f': {
                    b2.append('\f');
                    break;
                }
                case 's': {
                    b2.append(" \t\n\r\f");
                    break;
                }
                default: {
                    b2.append(c2);
                }
            }
            backSlashSeen = false;
        }
        return b2.toString();
    }

    public static long parseHumanSizes(String humanSize) throws Exception {
        long factor = 1L;
        char s2 = humanSize.charAt(0);
        switch (s2) {
            case '+': {
                humanSize = humanSize.substring(1);
                break;
            }
            case '-': {
                factor = -1L;
                humanSize = humanSize.substring(1);
                break;
            }
        }
        char c2 = humanSize.charAt(humanSize.length() - 1);
        if (!Character.isDigit(c2)) {
            int trim = 1;
            switch (c2) {
                case 'K': {
                    factor *= 1024L;
                    break;
                }
                case 'M': {
                    factor *= 0x100000L;
                    break;
                }
                case 'G': {
                    factor *= 0x40000000L;
                    break;
                }
                case 'T': {
                    factor *= 0x10000000000L;
                    break;
                }
                case 'P': {
                    factor *= 0x4000000000000L;
                    break;
                }
                default: {
                    trim = 0;
                }
            }
            humanSize = humanSize.substring(0, humanSize.length() - trim);
        }
        return factor * Long.parseLong(humanSize);
    }

    public static String removeSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String removePrefix(String string, String prefix) {
        if (string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }
}

