/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.regexp.Regexp;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class RegexpFactory
extends RegexpMatcherFactory {
    static /* synthetic */ Class class$org$apache$tools$ant$util$regexp$RegexpFactory;
    static /* synthetic */ Class class$org$apache$tools$ant$util$regexp$Regexp;

    public Regexp newRegexp() throws BuildException {
        return this.newRegexp(null);
    }

    public Regexp newRegexp(Project p2) throws BuildException {
        String systemDefault = null;
        systemDefault = p2 == null ? System.getProperty("ant.regexp.regexpimpl") : p2.getProperty("ant.regexp.regexpimpl");
        if (systemDefault != null) {
            return this.createRegexpInstance(systemDefault);
        }
        Throwable cause = null;
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createRegexpInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpRegexp");
        }
        catch (BuildException be2) {
            cause = RegexpFactory.orCause(cause, be2, JavaEnvUtils.getJavaVersionNumber() < 14);
            try {
                this.testAvailability("org.apache.oro.text.regex.Pattern");
                return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaOroRegexp");
            }
            catch (BuildException be3) {
                cause = RegexpFactory.orCause(cause, be3, true);
                try {
                    this.testAvailability("org.apache.regexp.RE");
                    return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaRegexpRegexp");
                }
                catch (BuildException be4) {
                    cause = RegexpFactory.orCause(cause, be4, true);
                    throw new BuildException("No supported regular expression matcher found" + (cause != null ? ": " + cause : ""), cause);
                }
            }
        }
    }

    protected Regexp createRegexpInstance(String classname) throws BuildException {
        return (Regexp)ClasspathUtils.newInstance(classname, (class$org$apache$tools$ant$util$regexp$RegexpFactory == null ? (class$org$apache$tools$ant$util$regexp$RegexpFactory = RegexpFactory.class$("org.apache.tools.ant.util.regexp.RegexpFactory")) : class$org$apache$tools$ant$util$regexp$RegexpFactory).getClassLoader(), class$org$apache$tools$ant$util$regexp$Regexp == null ? (class$org$apache$tools$ant$util$regexp$Regexp = RegexpFactory.class$("org.apache.tools.ant.util.regexp.Regexp")) : class$org$apache$tools$ant$util$regexp$Regexp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

