/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.regexp.RegexpMatcher;

public class RegexpMatcherFactory {
    static /* synthetic */ Class class$org$apache$tools$ant$util$regexp$RegexpMatcherFactory;
    static /* synthetic */ Class class$org$apache$tools$ant$util$regexp$RegexpMatcher;

    public RegexpMatcher newRegexpMatcher() throws BuildException {
        return this.newRegexpMatcher(null);
    }

    public RegexpMatcher newRegexpMatcher(Project p2) throws BuildException {
        String systemDefault = null;
        systemDefault = p2 == null ? System.getProperty("ant.regexp.regexpimpl") : p2.getProperty("ant.regexp.regexpimpl");
        if (systemDefault != null) {
            return this.createInstance(systemDefault);
        }
        Throwable cause = null;
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpMatcher");
        }
        catch (BuildException be2) {
            cause = RegexpMatcherFactory.orCause(cause, be2, JavaEnvUtils.getJavaVersionNumber() < 14);
            try {
                this.testAvailability("org.apache.oro.text.regex.Pattern");
                return this.createInstance("org.apache.tools.ant.util.regexp.JakartaOroMatcher");
            }
            catch (BuildException be3) {
                cause = RegexpMatcherFactory.orCause(cause, be3, true);
                try {
                    this.testAvailability("org.apache.regexp.RE");
                    return this.createInstance("org.apache.tools.ant.util.regexp.JakartaRegexpMatcher");
                }
                catch (BuildException be4) {
                    cause = RegexpMatcherFactory.orCause(cause, be4, true);
                    throw new BuildException("No supported regular expression matcher found" + (cause != null ? ": " + cause : ""), cause);
                }
            }
        }
    }

    static Throwable orCause(Throwable deflt, BuildException be2, boolean ignoreCnfe) {
        if (deflt != null) {
            return deflt;
        }
        Throwable t2 = be2.getException();
        return ignoreCnfe && t2 instanceof ClassNotFoundException ? null : t2;
    }

    protected RegexpMatcher createInstance(String className) throws BuildException {
        return (RegexpMatcher)ClasspathUtils.newInstance(className, (class$org$apache$tools$ant$util$regexp$RegexpMatcherFactory == null ? (class$org$apache$tools$ant$util$regexp$RegexpMatcherFactory = RegexpMatcherFactory.class$("org.apache.tools.ant.util.regexp.RegexpMatcherFactory")) : class$org$apache$tools$ant$util$regexp$RegexpMatcherFactory).getClassLoader(), class$org$apache$tools$ant$util$regexp$RegexpMatcher == null ? (class$org$apache$tools$ant$util$regexp$RegexpMatcher = RegexpMatcherFactory.class$("org.apache.tools.ant.util.regexp.RegexpMatcher")) : class$org$apache$tools$ant$util$regexp$RegexpMatcher);
    }

    protected void testAvailability(String className) throws BuildException {
        try {
            Class.forName(className);
        }
        catch (Throwable t2) {
            throw new BuildException(t2);
        }
    }

    public static boolean regexpMatcherPresent(Project project) {
        try {
            new RegexpMatcherFactory().newRegexpMatcher(project);
            return true;
        }
        catch (Throwable ex2) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

