/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.bzip2.BZip2Constants;
import org.apache.tools.bzip2.CRC;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final int GREATER_ICOST = 15;
    protected static final int LESSER_ICOST = 0;
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    protected static final int QSORT_STACK_SIZE = 1000;
    int last;
    int origPtr;
    int blockSize100k;
    boolean blockRandomised;
    int bytesOut;
    int bsBuff;
    int bsLive;
    CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private char[] block = null;
    private int[] quadrant = null;
    private int[] zptr = null;
    private short[] szptr;
    private int[] ftab = null;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int nBlocksRandomised;
    private int currentChar = -1;
    private int runLength = 0;
    boolean closed = false;
    private int blockCRC;
    private int combinedCRC;
    private int allowableBlockSize;
    private OutputStream bsStream;
    private int[] incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};

    private static void panic() {
        System.out.println("panic");
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (!this.inUse[i2]) continue;
            this.seqToUnseq[this.nInUse] = (char)i2;
            this.unseqToSeq[i2] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    protected static void hbMakeCodeLengths(char[] len, int[] freq, int alphaSize, int maxLen) {
        int i2;
        int[] heap = new int[260];
        int[] weight = new int[516];
        int[] parent = new int[516];
        for (i2 = 0; i2 < alphaSize; ++i2) {
            weight[i2 + 1] = (freq[i2] == 0 ? 1 : freq[i2]) << 8;
        }
        block1: while (true) {
            int j2;
            int tmp;
            int zz;
            int nNodes = alphaSize;
            int nHeap = 0;
            heap[0] = 0;
            weight[0] = 0;
            parent[0] = -2;
            for (i2 = 1; i2 <= alphaSize; ++i2) {
                parent[i2] = -1;
                heap[++nHeap] = i2;
                zz = nHeap;
                tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nHeap >= 260) {
                CBZip2OutputStream.panic();
            }
            while (nHeap > 1) {
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                int yy = 0;
                int tmp2 = 0;
                zz = 1;
                tmp2 = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp2] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp2;
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                yy = 0;
                tmp2 = 0;
                zz = 1;
                tmp2 = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp2] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp2;
                parent[n1] = parent[n2] = ++nNodes;
                weight[nNodes] = (weight[n1] & 0xFFFFFF00) + (weight[n2] & 0xFFFFFF00) | 1 + ((weight[n1] & 0xFF) > (weight[n2] & 0xFF) ? weight[n1] & 0xFF : weight[n2] & 0xFF);
                parent[nNodes] = -1;
                heap[++nHeap] = nNodes;
                zz = 0;
                tmp = 0;
                zz = nHeap;
                tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nNodes >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean tooLong = false;
            for (i2 = 1; i2 <= alphaSize; ++i2) {
                j2 = 0;
                int k2 = i2;
                while (parent[k2] >= 0) {
                    k2 = parent[k2];
                    ++j2;
                }
                len[i2 - 1] = (char)j2;
                if (j2 <= maxLen) continue;
                tooLong = true;
            }
            if (!tooLong) break;
            i2 = 1;
            while (true) {
                if (i2 >= alphaSize) continue block1;
                j2 = weight[i2] >> 8;
                j2 = 1 + j2 / 2;
                weight[i2] = j2 << 8;
                ++i2;
            }
            break;
        }
    }

    public CBZip2OutputStream(OutputStream inStream) throws IOException {
        this(inStream, 9);
    }

    public CBZip2OutputStream(OutputStream inStream, int inBlockSize) throws IOException {
        this.bsSetStream(inStream);
        this.workFactor = 50;
        if (inBlockSize > 9) {
            inBlockSize = 9;
        }
        if (inBlockSize < 1) {
            inBlockSize = 1;
        }
        this.blockSize100k = inBlockSize;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    public void write(int bv2) throws IOException {
        int b2 = (256 + bv2) % 256;
        if (this.currentChar != -1) {
            if (this.currentChar == b2) {
                ++this.runLength;
                if (this.runLength > 254) {
                    this.writeRun();
                    this.currentChar = -1;
                    this.runLength = 0;
                }
            } else {
                this.writeRun();
                this.runLength = 1;
                this.currentChar = b2;
            }
        } else {
            this.currentChar = b2;
            ++this.runLength;
        }
    }

    private void writeRun() throws IOException {
        if (this.last < this.allowableBlockSize) {
            this.inUse[this.currentChar] = true;
            for (int i2 = 0; i2 < this.runLength; ++i2) {
                this.mCrc.updateCRC((char)this.currentChar);
            }
            switch (this.runLength) {
                case 1: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                case 2: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                case 3: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                default: {
                    this.inUse[this.runLength - 4] = true;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)(this.runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private void initialize() throws IOException {
        this.bytesOut = 0;
        this.nBlocksRandomised = 0;
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.blockSize100k);
        this.combinedCRC = 0;
    }

    private void initBlock() {
        this.mCrc.initialiseCRC();
        this.last = -1;
        for (int i2 = 0; i2 < 256; ++i2) {
            this.inUse[i2] = false;
        }
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
    }

    private void endBlock() throws IOException {
        this.blockCRC = this.mCrc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= this.blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.blockCRC);
        if (this.blockRandomised) {
            this.bsW(1, 1);
            ++this.nBlocksRandomised;
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    private void hbAssignCodes(int[] code, char[] length, int minLen, int maxLen, int alphaSize) {
        int vec = 0;
        for (int n2 = minLen; n2 <= maxLen; ++n2) {
            for (int i2 = 0; i2 < alphaSize; ++i2) {
                if (length[i2] != n2) continue;
                code[i2] = vec++;
            }
            vec <<= 1;
        }
    }

    private void bsSetStream(OutputStream f2) {
        this.bsStream = f2;
        this.bsLive = 0;
        this.bsBuff = 0;
        this.bytesOut = 0;
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            int ch2 = this.bsBuff >> 24;
            this.bsStream.write(ch2);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
            ++this.bytesOut;
        }
    }

    private void bsW(int n2, int v2) throws IOException {
        while (this.bsLive >= 8) {
            int ch2 = this.bsBuff >> 24;
            this.bsStream.write(ch2);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
            ++this.bytesOut;
        }
        this.bsBuff |= v2 << 32 - this.bsLive - n2;
        this.bsLive += n2;
    }

    private void bsPutUChar(int c2) throws IOException {
        this.bsW(8, c2);
    }

    private void bsPutint(int u2) throws IOException {
        this.bsW(8, u2 >> 24 & 0xFF);
        this.bsW(8, u2 >> 16 & 0xFF);
        this.bsW(8, u2 >> 8 & 0xFF);
        this.bsW(8, u2 & 0xFF);
    }

    private void bsPutIntVS(int numBits, int c2) throws IOException {
        this.bsW(numBits, c2);
    }

    private void sendMTFValues() throws IOException {
        int j2;
        int i2;
        int ge2;
        int v2;
        int t2;
        char[][] len = new char[6][258];
        int nSelectors = 0;
        int alphaSize = this.nInUse + 2;
        for (t2 = 0; t2 < 6; ++t2) {
            for (int v22 = 0; v22 < alphaSize; ++v22) {
                len[t2][v22] = 15;
            }
        }
        if (this.nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int nGroups = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        int nPart = nGroups;
        int remF = this.nMTF;
        int gs2 = 0;
        while (nPart > 0) {
            int aFreq;
            int tFreq = remF / nPart;
            int ge22 = gs2 - 1;
            for (aFreq = 0; aFreq < tFreq && ge22 < alphaSize - 1; aFreq += this.mtfFreq[++ge22]) {
            }
            if (ge22 > gs2 && nPart != nGroups && nPart != 1 && (nGroups - nPart) % 2 == 1) {
                aFreq -= this.mtfFreq[ge22];
                --ge22;
            }
            for (v2 = 0; v2 < alphaSize; ++v2) {
                len[nPart - 1][v2] = v2 >= gs2 && v2 <= ge22 ? 0 : 15;
            }
            --nPart;
            gs2 = ge22 + 1;
            remF -= aFreq;
        }
        int[][] rfreq = new int[6][258];
        int[] fave = new int[6];
        short[] cost = new short[6];
        for (int iter = 0; iter < 4; ++iter) {
            for (t2 = 0; t2 < nGroups; ++t2) {
                fave[t2] = 0;
            }
            for (t2 = 0; t2 < nGroups; ++t2) {
                for (v2 = 0; v2 < alphaSize; ++v2) {
                    rfreq[t2][v2] = 0;
                }
            }
            nSelectors = 0;
            int totc = 0;
            gs2 = 0;
            while (gs2 < this.nMTF) {
                int i3;
                ge2 = gs2 + 50 - 1;
                if (ge2 >= this.nMTF) {
                    ge2 = this.nMTF - 1;
                }
                for (t2 = 0; t2 < nGroups; ++t2) {
                    cost[t2] = 0;
                }
                if (nGroups == 6) {
                    short cost5 = 0;
                    short cost4 = 0;
                    short cost3 = 0;
                    short cost2 = 0;
                    short cost1 = 0;
                    short cost0 = 0;
                    for (i3 = gs2; i3 <= ge2; ++i3) {
                        short icv = this.szptr[i3];
                        cost0 = (short)(cost0 + len[0][icv]);
                        cost1 = (short)(cost1 + len[1][icv]);
                        cost2 = (short)(cost2 + len[2][icv]);
                        cost3 = (short)(cost3 + len[3][icv]);
                        cost4 = (short)(cost4 + len[4][icv]);
                        cost5 = (short)(cost5 + len[5][icv]);
                    }
                    cost[0] = cost0;
                    cost[1] = cost1;
                    cost[2] = cost2;
                    cost[3] = cost3;
                    cost[4] = cost4;
                    cost[5] = cost5;
                } else {
                    for (i3 = gs2; i3 <= ge2; ++i3) {
                        short icv = this.szptr[i3];
                        for (t2 = 0; t2 < nGroups; ++t2) {
                            int n2 = t2;
                            cost[n2] = (short)(cost[n2] + len[t2][icv]);
                        }
                    }
                }
                short s2 = 999999999;
                int bt2 = -1;
                for (t2 = 0; t2 < nGroups; ++t2) {
                    if (cost[t2] >= s2) continue;
                    s2 = cost[t2];
                    bt2 = t2;
                }
                totc += s2;
                int n3 = bt2;
                fave[n3] = fave[n3] + 1;
                this.selector[nSelectors] = (char)bt2;
                ++nSelectors;
                for (i3 = gs2; i3 <= ge2; ++i3) {
                    int[] nArray = rfreq[bt2];
                    short s3 = this.szptr[i3];
                    nArray[s3] = nArray[s3] + 1;
                }
                gs2 = ge2 + 1;
            }
            for (t2 = 0; t2 < nGroups; ++t2) {
                CBZip2OutputStream.hbMakeCodeLengths(len[t2], rfreq[t2], alphaSize, 20);
            }
        }
        rfreq = null;
        fave = null;
        cost = null;
        if (nGroups >= 8) {
            CBZip2OutputStream.panic();
        }
        if (nSelectors >= 32768 || nSelectors > 18002) {
            CBZip2OutputStream.panic();
        }
        char[] pos = new char[6];
        for (i2 = 0; i2 < nGroups; ++i2) {
            pos[i2] = (char)i2;
        }
        for (i2 = 0; i2 < nSelectors; ++i2) {
            char ll_i = this.selector[i2];
            int j22 = 0;
            char tmp = pos[j22];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = pos[++j22];
                pos[j22] = tmp2;
            }
            pos[0] = tmp;
            this.selectorMtf[i2] = (char)j22;
        }
        int[][] code = new int[6][258];
        for (t2 = 0; t2 < nGroups; ++t2) {
            char minLen = ' ';
            char maxLen = '\u0000';
            for (i2 = 0; i2 < alphaSize; ++i2) {
                if (len[t2][i2] > maxLen) {
                    maxLen = len[t2][i2];
                }
                if (len[t2][i2] >= minLen) continue;
                minLen = len[t2][i2];
            }
            if (maxLen > '\u0014') {
                CBZip2OutputStream.panic();
            }
            if (minLen < '\u0001') {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes(code[t2], len[t2], minLen, maxLen, alphaSize);
        }
        boolean[] inUse16 = new boolean[16];
        for (i2 = 0; i2 < 16; ++i2) {
            inUse16[i2] = false;
            for (j2 = 0; j2 < 16; ++j2) {
                if (!this.inUse[i2 * 16 + j2]) continue;
                inUse16[i2] = true;
            }
        }
        int nBytes = this.bytesOut;
        for (i2 = 0; i2 < 16; ++i2) {
            if (inUse16[i2]) {
                this.bsW(1, 1);
                continue;
            }
            this.bsW(1, 0);
        }
        for (i2 = 0; i2 < 16; ++i2) {
            if (!inUse16[i2]) continue;
            for (j2 = 0; j2 < 16; ++j2) {
                if (this.inUse[i2 * 16 + j2]) {
                    this.bsW(1, 1);
                    continue;
                }
                this.bsW(1, 0);
            }
        }
        nBytes = this.bytesOut;
        this.bsW(3, nGroups);
        this.bsW(15, nSelectors);
        for (i2 = 0; i2 < nSelectors; ++i2) {
            for (j2 = 0; j2 < this.selectorMtf[i2]; ++j2) {
                this.bsW(1, 1);
            }
            this.bsW(1, 0);
        }
        nBytes = this.bytesOut;
        for (t2 = 0; t2 < nGroups; ++t2) {
            int curr = len[t2][0];
            this.bsW(5, curr);
            for (i2 = 0; i2 < alphaSize; ++i2) {
                while (curr < len[t2][i2]) {
                    this.bsW(2, 2);
                    ++curr;
                }
                while (curr > len[t2][i2]) {
                    this.bsW(2, 3);
                    --curr;
                }
                this.bsW(1, 0);
            }
        }
        nBytes = this.bytesOut;
        int selCtr = 0;
        gs2 = 0;
        while (gs2 < this.nMTF) {
            ge2 = gs2 + 50 - 1;
            if (ge2 >= this.nMTF) {
                ge2 = this.nMTF - 1;
            }
            for (i2 = gs2; i2 <= ge2; ++i2) {
                this.bsW(len[this.selector[selCtr]][this.szptr[i2]], code[this.selector[selCtr]][this.szptr[i2]]);
            }
            gs2 = ge2 + 1;
            ++selCtr;
        }
        if (selCtr != nSelectors) {
            CBZip2OutputStream.panic();
        }
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void simpleSort(int lo, int hi2, int d2) {
        int bigN = hi2 - lo + 1;
        if (bigN < 2) {
            return;
        }
        int hp = 0;
        while (this.incs[hp] < bigN) {
            ++hp;
        }
        --hp;
        while (hp >= 0) {
            int h2 = this.incs[hp];
            for (int i2 = lo + h2; i2 <= hi2; ++i2) {
                int v2 = this.zptr[i2];
                int j2 = i2;
                while (this.fullGtU(this.zptr[j2 - h2] + d2, v2 + d2)) {
                    this.zptr[j2] = this.zptr[j2 - h2];
                    if ((j2 -= h2) > lo + h2 - 1) continue;
                }
                this.zptr[j2] = v2;
                if (++i2 > hi2) break;
                v2 = this.zptr[i2];
                j2 = i2;
                while (this.fullGtU(this.zptr[j2 - h2] + d2, v2 + d2)) {
                    this.zptr[j2] = this.zptr[j2 - h2];
                    if ((j2 -= h2) > lo + h2 - 1) continue;
                }
                this.zptr[j2] = v2;
                if (++i2 > hi2) break;
                v2 = this.zptr[i2];
                j2 = i2;
                while (this.fullGtU(this.zptr[j2 - h2] + d2, v2 + d2)) {
                    this.zptr[j2] = this.zptr[j2 - h2];
                    if ((j2 -= h2) > lo + h2 - 1) continue;
                }
                this.zptr[j2] = v2;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --hp;
        }
    }

    private void vswap(int p1, int p2, int n2) {
        int temp = 0;
        while (n2 > 0) {
            temp = this.zptr[p1];
            this.zptr[p1] = this.zptr[p2];
            this.zptr[p2] = temp;
            ++p1;
            ++p2;
            --n2;
        }
    }

    private char med3(char a2, char b2, char c2) {
        char t2;
        if (a2 > b2) {
            t2 = a2;
            a2 = b2;
            b2 = t2;
        }
        if (b2 > c2) {
            t2 = b2;
            b2 = c2;
            c2 = t2;
        }
        if (a2 > b2) {
            b2 = a2;
        }
        return b2;
    }

    private void qSort3(int loSt, int hiSt, int dSt) {
        StackElem[] stack = new StackElem[1000];
        for (int count = 0; count < 1000; ++count) {
            stack[count] = new StackElem();
        }
        int sp = 0;
        stack[sp].ll = loSt;
        stack[sp].hh = hiSt;
        stack[sp].dd = dSt;
        ++sp;
        while (sp > 0) {
            int n2;
            int gtHi;
            int ltLo;
            if (sp >= 1000) {
                CBZip2OutputStream.panic();
            }
            int lo = stack[--sp].ll;
            int hi2 = stack[sp].hh;
            int d2 = stack[sp].dd;
            if (hi2 - lo < 20 || d2 > 10) {
                this.simpleSort(lo, hi2, d2);
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            char med = this.med3(this.block[this.zptr[lo] + d2 + 1], this.block[this.zptr[hi2] + d2 + 1], this.block[this.zptr[lo + hi2 >> 1] + d2 + 1]);
            int unLo = ltLo = lo;
            int unHi = gtHi = hi2;
            while (true) {
                int temp;
                if (unLo <= unHi) {
                    n2 = this.block[this.zptr[unLo] + d2 + 1] - med;
                    if (n2 == 0) {
                        temp = 0;
                        temp = this.zptr[unLo];
                        this.zptr[unLo] = this.zptr[ltLo];
                        this.zptr[ltLo] = temp;
                        ++ltLo;
                        ++unLo;
                        continue;
                    }
                    if (n2 <= 0) {
                        ++unLo;
                        continue;
                    }
                }
                while (unLo <= unHi) {
                    n2 = this.block[this.zptr[unHi] + d2 + 1] - med;
                    if (n2 == 0) {
                        temp = 0;
                        temp = this.zptr[unHi];
                        this.zptr[unHi] = this.zptr[gtHi];
                        this.zptr[gtHi] = temp;
                        --gtHi;
                        --unHi;
                        continue;
                    }
                    if (n2 < 0) break;
                    --unHi;
                }
                if (unLo > unHi) break;
                temp = 0;
                temp = this.zptr[unLo];
                this.zptr[unLo] = this.zptr[unHi];
                this.zptr[unHi] = temp;
                ++unLo;
                --unHi;
            }
            if (gtHi < ltLo) {
                stack[sp].ll = lo;
                stack[sp].hh = hi2;
                stack[sp].dd = d2 + 1;
                ++sp;
                continue;
            }
            n2 = ltLo - lo < unLo - ltLo ? ltLo - lo : unLo - ltLo;
            this.vswap(lo, unLo - n2, n2);
            int m2 = hi2 - gtHi < gtHi - unHi ? hi2 - gtHi : gtHi - unHi;
            this.vswap(unLo, hi2 - m2 + 1, m2);
            n2 = lo + unLo - ltLo - 1;
            m2 = hi2 - (gtHi - unHi) + 1;
            stack[sp].ll = lo;
            stack[sp].hh = n2;
            stack[sp].dd = d2;
            stack[++sp].ll = n2 + 1;
            stack[sp].hh = m2 - 1;
            stack[sp].dd = d2 + 1;
            stack[++sp].ll = m2;
            stack[sp].hh = hi2;
            stack[sp].dd = d2;
            ++sp;
        }
    }

    private void mainSort() {
        int i2;
        int[] runningOrder = new int[256];
        int[] copy = new int[256];
        boolean[] bigDone = new boolean[256];
        for (i2 = 0; i2 < 20; ++i2) {
            this.block[this.last + i2 + 2] = this.block[i2 % (this.last + 1) + 1];
        }
        for (i2 = 0; i2 <= this.last + 20; ++i2) {
            this.quadrant[i2] = 0;
        }
        this.block[0] = this.block[this.last + 1];
        if (this.last < 4000) {
            for (i2 = 0; i2 <= this.last; ++i2) {
                this.zptr[i2] = i2;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.last, 0);
        } else {
            int j2;
            char c2;
            int numQSorted = 0;
            for (i2 = 0; i2 <= 255; ++i2) {
                bigDone[i2] = false;
            }
            for (i2 = 0; i2 <= 65536; ++i2) {
                this.ftab[i2] = 0;
            }
            char c1 = this.block[0];
            for (i2 = 0; i2 <= this.last; ++i2) {
                c2 = this.block[i2 + 1];
                int n2 = (c1 << 8) + c2;
                this.ftab[n2] = this.ftab[n2] + 1;
                c1 = c2;
            }
            for (i2 = 1; i2 <= 65536; ++i2) {
                int n3 = i2;
                this.ftab[n3] = this.ftab[n3] + this.ftab[i2 - 1];
            }
            c1 = this.block[1];
            i2 = 0;
            while (i2 < this.last) {
                c2 = this.block[i2 + 2];
                j2 = (c1 << 8) + c2;
                c1 = c2;
                int n4 = j2;
                this.ftab[n4] = this.ftab[n4] - 1;
                this.zptr[this.ftab[j2]] = i2++;
            }
            int n5 = j2 = (this.block[this.last + 1] << 8) + this.block[1];
            this.ftab[n5] = this.ftab[n5] - 1;
            this.zptr[this.ftab[j2]] = this.last;
            for (i2 = 0; i2 <= 255; ++i2) {
                runningOrder[i2] = i2;
            }
            int h2 = 1;
            while ((h2 = 3 * h2 + 1) <= 256) {
            }
            do {
                for (i2 = h2 /= 3; i2 <= 255; ++i2) {
                    int vv = runningOrder[i2];
                    j2 = i2;
                    while (this.ftab[runningOrder[j2 - h2] + 1 << 8] - this.ftab[runningOrder[j2 - h2] << 8] > this.ftab[vv + 1 << 8] - this.ftab[vv << 8]) {
                        runningOrder[j2] = runningOrder[j2 - h2];
                        if ((j2 -= h2) > h2 - 1) continue;
                    }
                    runningOrder[j2] = vv;
                }
            } while (h2 != 1);
            for (i2 = 0; i2 <= 255; ++i2) {
                int ss = runningOrder[i2];
                for (j2 = 0; j2 <= 255; ++j2) {
                    int sb = (ss << 8) + j2;
                    if ((this.ftab[sb] & 0x200000) == 0x200000) continue;
                    int hi2 = (this.ftab[sb + 1] & 0xFFDFFFFF) - 1;
                    int lo = this.ftab[sb] & 0xFFDFFFFF;
                    if (hi2 > lo) {
                        this.qSort3(lo, hi2, 2);
                        numQSorted += hi2 - lo + 1;
                        if (this.workDone > this.workLimit && this.firstAttempt) {
                            return;
                        }
                    }
                    int n6 = sb;
                    this.ftab[n6] = this.ftab[n6] | 0x200000;
                }
                bigDone[ss] = true;
                if (i2 < 255) {
                    int bbStart = this.ftab[ss << 8] & 0xFFDFFFFF;
                    int bbSize = (this.ftab[ss + 1 << 8] & 0xFFDFFFFF) - bbStart;
                    int shifts = 0;
                    while (bbSize >> shifts > 65534) {
                        ++shifts;
                    }
                    for (j2 = 0; j2 < bbSize; ++j2) {
                        int qVal;
                        int a2update = this.zptr[bbStart + j2];
                        this.quadrant[a2update] = qVal = j2 >> shifts;
                        if (a2update >= 20) continue;
                        this.quadrant[a2update + this.last + 1] = qVal;
                    }
                    if (bbSize - 1 >> shifts > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                for (j2 = 0; j2 <= 255; ++j2) {
                    copy[j2] = this.ftab[(j2 << 8) + ss] & 0xFFDFFFFF;
                }
                for (j2 = this.ftab[ss << 8] & 0xFFDFFFFF; j2 < (this.ftab[ss + 1 << 8] & 0xFFDFFFFF); ++j2) {
                    c1 = this.block[this.zptr[j2]];
                    if (bigDone[c1]) continue;
                    this.zptr[copy[c1]] = this.zptr[j2] == 0 ? this.last : this.zptr[j2] - 1;
                    char c3 = c1;
                    copy[c3] = copy[c3] + 1;
                }
                for (j2 = 0; j2 <= 255; ++j2) {
                    int n7 = (j2 << 8) + ss;
                    this.ftab[n7] = this.ftab[n7] | 0x200000;
                }
            }
        }
    }

    private void randomiseBlock() {
        int i2;
        int rNToGo = 0;
        int rTPos = 0;
        for (i2 = 0; i2 < 256; ++i2) {
            this.inUse[i2] = false;
        }
        for (i2 = 0; i2 <= this.last; ++i2) {
            if (rNToGo == 0) {
                rNToGo = (char)BZip2Constants.rNums[rTPos];
                if (++rTPos == 512) {
                    rTPos = 0;
                }
            }
            int n2 = i2 + 1;
            this.block[n2] = (char)(this.block[n2] ^ (--rNToGo == 1 ? (char)'\u0001' : '\u0000'));
            int n3 = i2 + 1;
            this.block[n3] = (char)(this.block[n3] & 0xFF);
            this.inUse[this.block[i2 + 1]] = true;
        }
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * this.last;
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        for (int i2 = 0; i2 <= this.last; ++i2) {
            if (this.zptr[i2] != 0) continue;
            this.origPtr = i2;
            break;
        }
        if (this.origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private boolean fullGtU(int i1, int i2) {
        char c1 = this.block[i1 + 1];
        char c2 = this.block[i2 + 1];
        if (c1 != c2) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
            return c1 > c2;
        }
        ++i1;
        ++i2;
        int k2 = this.last + 1;
        do {
            if ((c1 = this.block[i1 + 1]) != (c2 = this.block[i2 + 1])) {
                return c1 > c2;
            }
            int s1 = this.quadrant[i1];
            int s2 = this.quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.quadrant[i1];
            s2 = this.quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.quadrant[i1];
            s2 = this.quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.block[++i1 + 1]) != (c2 = this.block[++i2 + 1])) {
                return c1 > c2;
            }
            s1 = this.quadrant[i1];
            s2 = this.quadrant[i2];
            if (s1 != s2) {
                return s1 > s2;
            }
            ++i2;
            if (++i1 > this.last) {
                i1 -= this.last;
                --i1;
            }
            if (i2 > this.last) {
                i2 -= this.last;
                --i2;
            }
            ++this.workDone;
        } while ((k2 -= 4) >= 0);
        return false;
    }

    private void allocateCompressStructures() {
        int n2 = 100000 * this.blockSize100k;
        this.block = new char[n2 + 1 + 20];
        this.quadrant = new int[n2 + 20];
        this.zptr = new int[n2];
        this.ftab = new int[65537];
        if (this.block == null || this.quadrant == null || this.zptr == null || this.ftab == null) {
            // empty if block
        }
        this.szptr = new short[2 * n2];
    }

    private void generateMTFValues() {
        int i2;
        char[] yy = new char[256];
        this.makeMaps();
        int EOB = this.nInUse + 1;
        for (i2 = 0; i2 <= EOB; ++i2) {
            this.mtfFreq[i2] = 0;
        }
        int wr = 0;
        int zPend = 0;
        for (i2 = 0; i2 < this.nInUse; ++i2) {
            yy[i2] = (char)i2;
        }
        for (i2 = 0; i2 <= this.last; ++i2) {
            char ll_i = this.unseqToSeq[this.block[this.zptr[i2]]];
            int j2 = 0;
            char tmp = yy[j2];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = yy[++j2];
                yy[j2] = tmp2;
            }
            yy[0] = tmp;
            if (j2 == 0) {
                ++zPend;
                continue;
            }
            if (zPend > 0) {
                --zPend;
                while (true) {
                    switch (zPend % 2) {
                        case 0: {
                            this.szptr[wr] = 0;
                            ++wr;
                            this.mtfFreq[0] = this.mtfFreq[0] + 1;
                            break;
                        }
                        case 1: {
                            this.szptr[wr] = 1;
                            ++wr;
                            this.mtfFreq[1] = this.mtfFreq[1] + 1;
                        }
                    }
                    if (zPend < 2) break;
                    zPend = (zPend - 2) / 2;
                }
                zPend = 0;
            }
            this.szptr[wr] = (short)(j2 + 1);
            ++wr;
            int n2 = j2 + 1;
            this.mtfFreq[n2] = this.mtfFreq[n2] + 1;
        }
        if (zPend > 0) {
            --zPend;
            while (true) {
                switch (zPend % 2) {
                    case 0: {
                        this.szptr[wr] = 0;
                        ++wr;
                        this.mtfFreq[0] = this.mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.szptr[wr] = 1;
                        ++wr;
                        this.mtfFreq[1] = this.mtfFreq[1] + 1;
                    }
                }
                if (zPend < 2) break;
                zPend = (zPend - 2) / 2;
            }
        }
        this.szptr[wr] = (short)EOB;
        int n3 = EOB;
        this.mtfFreq[n3] = this.mtfFreq[n3] + 1;
        this.nMTF = ++wr;
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        private StackElem() {
        }
    }
}

