/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.zip.UnrecognizedExtraField;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static Hashtable implementations = new Hashtable();
    static /* synthetic */ Class class$org$apache$tools$zip$AsiExtraField;
    static /* synthetic */ Class class$org$apache$tools$zip$JarMarker;

    public static void register(Class c2) {
        try {
            ZipExtraField ze = (ZipExtraField)c2.newInstance();
            implementations.put(ze.getHeaderId(), c2);
        }
        catch (ClassCastException cc2) {
            throw new RuntimeException(c2 + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(c2 + " is not a concrete class");
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(c2 + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        Class c2 = (Class)implementations.get(headerId);
        if (c2 != null) {
            return (ZipExtraField)c2.newInstance();
        }
        UnrecognizedExtraField u2 = new UnrecognizedExtraField();
        u2.setHeaderId(headerId);
        return u2;
    }

    public static ZipExtraField[] parse(byte[] data) throws ZipException {
        int start;
        int length;
        Vector<ZipExtraField> v2 = new Vector<ZipExtraField>();
        for (start = 0; start <= data.length - 4; start += length + 4) {
            ZipShort headerId = new ZipShort(data, start);
            length = new ZipShort(data, start + 2).getValue();
            if (start + 4 + length > data.length) {
                throw new ZipException("data starting at " + start + " is in unknown format");
            }
            try {
                ZipExtraField ze = ExtraFieldUtils.createExtraField(headerId);
                ze.parseFromLocalFileData(data, start + 4, length);
                v2.addElement(ze);
                continue;
            }
            catch (InstantiationException ie) {
                throw new ZipException(ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ZipException(iae.getMessage());
            }
        }
        if (start != data.length) {
            throw new ZipException("data starting at " + start + " is in unknown format");
        }
        Object[] result = new ZipExtraField[v2.size()];
        v2.copyInto(result);
        return result;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data) {
        int sum = 4 * data.length;
        for (int i2 = 0; i2 < data.length; ++i2) {
            sum += data[i2].getLocalFileDataLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (int i3 = 0; i3 < data.length; ++i3) {
            System.arraycopy(data[i3].getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i3].getLocalFileDataLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = data[i3].getLocalFileDataData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
        }
        return result;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data) {
        int sum = 4 * data.length;
        for (int i2 = 0; i2 < data.length; ++i2) {
            sum += data[i2].getCentralDirectoryLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (int i3 = 0; i3 < data.length; ++i3) {
            System.arraycopy(data[i3].getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i3].getCentralDirectoryLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = data[i3].getCentralDirectoryData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ExtraFieldUtils.register(class$org$apache$tools$zip$AsiExtraField == null ? (class$org$apache$tools$zip$AsiExtraField = ExtraFieldUtils.class$("org.apache.tools.zip.AsiExtraField")) : class$org$apache$tools$zip$AsiExtraField);
        ExtraFieldUtils.register(class$org$apache$tools$zip$JarMarker == null ? (class$org$apache$tools$zip$JarMarker = ExtraFieldUtils.class$("org.apache.tools.zip.JarMarker")) : class$org$apache$tools$zip$JarMarker);
    }
}

