/**
 * encrypt a json to save transfer to the server
 * @param json the json to encrypt
 * @returns {string} the encrypted json
 */
var encrypt = function (json) {
    var result = "";
    var xor = 0x47;
    var l = json.length;
    for (var i = 0; i < l; i++) {
        var code = json.charCodeAt(i);
        var nextXor = (code & 0xFF);
        result = result + String.fromCharCode(code ^ xor);
        xor = nextXor;
    }
    return result;
};

/**
 * Returns the json object for the given received data. It will be decrypted and converted if the data is a string. For IE8, the stream is not encrypted, so the object is the resulting instance.
 * @param data the received data from POST request. Needs to be deserialized if it is type of "string"
 * @returns the deserialized json object
 */
var extractJson = function ( data ) {
	if (typeof data == "string") {
		return JSON.parse( decrypt( data ) );
	} else {
		return data;
	}
}

/**
 * decrypt a json from the server
 * @param qwirks the string to decrypt
 * @returns {string} the decrypted json
 */
var decrypt = function (qwirks) {
    if (qwirks && qwirks.charCodeAt(0) === 123 /* '{' */) {
        return qwirks;
    }
    var result = "";
    var l = qwirks.length;
    var xor = 0x47;
    for (var i = 0; i < l; i++) {
        var code = qwirks.charCodeAt(i);
        xor = (code ^ xor);
        result = result + String.fromCharCode(xor);
        xor &= 0xFF;
    }
    return result;
};
