angular.module('translate', [])
    .directive('ngI18n', function () {
        return {
            // 'A': only as attribute
            restrict: 'A',
            link: function postLink(scope, element, attrs) {
                attrs.$observe('ngI18n', function (value) {
                    if (!value) {
                        // Well, seems that we don't have anything to translate...
                        return;
                    }
                    setText(element, value);

                });
            }
        };
        /**
         * Translate the string given by the ng-i18next attribute and put it into the element.
         * @param {DOMElement} element     Element with the ng-i18next attribute
         * @param {String} translateString The string we want to translate
         */
        function setText(element, string) {

            var translateString = getMsg(string);

            element.text(translateString);
            if ('placeholder' in $(element).valueOf()[0]) {
                $(element).valueOf()[0].placeholder = translateString;
            }
        }
    });

var locale;

function getMsg(string) {

    if (locale == null || locale == undefined || locale == "") {
        locale = $('html').attr('lang');
        if (locale == null || locale == undefined || locale == "") {
            if (typeof navigator.language != 'undefined') {
                locale = navigator.language;
            } else if (typeof navigator.userLanguage != 'undefined') {
                locale = navigator.userLanguage;
            } else {
                locale = 'en';
            }
        }
    }

    locale = locale.substring(0, 2);

    var langpack = i18n[locale];
    if (langpack == null || langpack == undefined) {
        langpack = i18n.en;
    }
    var translateString = langpack[string]
    if (translateString == null || translateString == undefined || translateString == "") {
        translateString = "{" + string + "}";
    }
    return translateString;
};