'use strict';

var i18n = {
    de: {
        sessionquit: "Die Sitzung wurde erfolgreich beendet. Sie werden nun zur i-net Clear Reports Startseite weitergeleitet."
    },
    en: {
        sessionquit: "Your session ended successfully. You will be redirected to the i-net Clear Reports start page."
    }
}

function module($scope, $timeout, $http) {
    $scope.url = $('base').attr("href");
    $scope.baseurl = $scope.url.substring(0, $scope.url.length - "remote/".length);


    $http.post($scope.url + "logout", JSON.stringify({
            "logout": true
        })).success(function (data, status) {

            var obj = extractJson(data);

            var redUrl = obj.redirectPath;
            if (redUrl != null && redUrl == "" && redUrl != undefined) {
                $scope.baseurl = redUrl;
            }
            $timeout($scope.onTimeout, 3000);

        }).error(function (data, status) {
            console.log("error");
            $timeout($scope.onTimeout, 3000);
        });

    /*$scope.$on('$includeContentLoaded', $scope.doPost );*/

    $scope.onTimeout = function () {
        window.location.href = $scope.baseurl;
    };
}

