'use strict';

var i18n = {
    de: {
        logout: "Ausloggen",
        errormsg1: "Es konnten keine Module gefunden werden.",
        errormsg2: "Möglicherweise haben Sie nicht die Rechte um eines der Module anzuzeigen.",
        errormsg3: "Bitte wenden Sie sich an Ihren lokalen Administrator.",
        retry: "Erneut versuchen",
        admin: "Administrator",
        error: "Fehler",
        errordata: "Es wurden keine Daten vom Server empfangen.",
        unknownversion: "Unbekannte Version"

    },
    en: {
        logout: "Logout",
        errormsg1: "No modules found.",
        errormsg2: "Maybe you don't not have access to any module.",
        errormsg3: "Please contact your local administrator.",
        retry: "Retry",
        admin: "Administrator",
        error: "Error",
        errordata: "Did not receive any data from server.",
        unknownversion: "unknown version"
    }
}

function module($scope, $http) {
    $scope.pocessingData = false;
    $scope.modules = [];
    $scope.user = "";
    $scope.error = [];
    $scope.error.header = "";
    $scope.error.body = "";
    $scope.moduleshash = [];
    $scope.moduleready = false;
    $scope.reloadaftererror = false;
    $scope.nomodules = false;

    /**
     * initial connection to the server
     */
    $scope.url = $('base').attr("href");
    $scope.baseurl = $scope.url.substring(0, $scope.url.length - "remote/".length);
    $http.post($scope.url.substring(0, $scope.url.length - 1) ).success(function (data, status) {
            $scope.pocessingData = false;

            if (status != 200) {
                $scope.reloadaftererror = true;
                $scope.showError(getMsg('error') + status, data);
                return;
            }

            if (!data) {
                $scope.reloadaftererror = true;
                $scope.showError(getMsg('error'), getMsg('errordata'));
                return;
            }

            var obj = extractJson(data);
            $scope.user = obj.user;

            if (obj.user == undefined || obj.user == null) {
                $scope.user = getMsg('admin');
            }

            $scope.version = obj.version;

            if (obj.version == undefined || obj.version == null) {
                $scope.version = getMsg('unknownversion');
            }

            if (obj.modules == undefined || obj.modules == null || obj.modules.length == 0) {
                $scope.nomodules = true
                $('#centerwrapper_nomodules').css("opacity", "1");
                return;
            } else {
                $scope.nomodules = false
                $('#centerwrapper_nomodules').css("opacity", "1");
            }

            $scope.modules = obj.modules;

            angular.forEach($scope.modules, function (module) {
                module.id = module.path.substr(1);
            });

            $scope.pocessingData = true;
        }).
        error(function (data, status) {
            $scope.pocessingData = false;
            $scope.reloadaftererror = true;
            $scope.showError(getMsg('error'), data);
        });

    var defaultOptions = {
        align: 'center',
        container: $('#centerframe'),
        offset: 0,
        autoResize: true,
        itemWidth: 240,
        flexibleWidth: 240,
        resizeDelay: 0
    };

    $scope.doLayout = function (isLast) {
        if (isLast == true) {
            var defaultOptions = {
                align: 'center',
                container: $('#centerframe'),
                offset: 0,
                autoResize: true,
                itemWidth: 240,
                flexibleWidth: 240,
                resizeDelay: 0
            };

            var handler = $('#modulelist li');
            // Call the layout function.
            handler.wookmark(defaultOptions);
            $('#centerwrapper').css("opacity", "1");
            $scope.moduleready = true;
        }
    }

    /**
     * logout the user
     */
    $scope.logout = function () {
        var url = $('base').attr("href");
        window.location.href = url + 'logout';
    };

    /**
     * showing the error dialog
     * @param header the header / headline
     * @param body the body, can be html or string
     */
    $scope.showError = function (header, body) {
        $scope.error.header = header;
        $scope.error.body = body;
        $('#errordialogbody').html(body);
        console.error(getMsg('error') + header);
        $('#errordialog').modal({backdrop: 'static', keyboard: false, show: true});
    };

    /**
     * if the var reloadaftererror is true, it triggers a reload
     */
    $scope.errorbuttonaction = function () {
        if ($scope.reloadaftererror == true) {
            var url = $('base').attr("href");
            window.location.href = url;
        }
    };
}

/**
 * calculates the popover space and switches between top and bottom
 * @param popoverHeight
 * @param element
 * @returns {string}
 */
function popoverPlacement(popoverHeight, element) {
    var offset = element.offset().top;
    var height = popoverHeight + element.height();
    var docheight = $(document).height();

    if (offset + height >= docheight) {
        return "top";
    }
    else {
        return "bottom"
    }
}