/**
 * Pseudo event handler to be fired after the DOM was parsed or
 * on window load at last.
 *
 * @author based upon some code by Dean Edwards
 * @author Dean Edwards
 * @link   http://dean.edwards.name/weblog/2006/06/again/
 */
window.fireoninit = function() {
  // quit if this function has already been called
  if (arguments.callee.done) return;
  // flag this function so we don't do the same thing twice
  arguments.callee.done = true;
  // kill the timer
  if (_timer) {
     clearInterval(_timer);
     _timer = null;
  }

  if (typeof window.oninit == 'function') {
        window.oninit();
  }
};

/**
 * Run the fireoninit function as soon as possible after
 * the DOM was loaded, using different methods for different
 * Browsers
 *
 * @author Dean Edwards
 * @link   http://dean.edwards.name/weblog/2006/06/again/
 */
  // for Mozilla
  if (document.addEventListener) {
    document.addEventListener("DOMContentLoaded", window.fireoninit, null);
  }

  // for Internet Explorer (using conditional comments)
  /*@cc_on
    @if (@_win32)
    document.write("<scr" + "ipt id=\"__ie_init\" defer=\"true\" src=\"//:\"><\/script>");
    var script = document.getElementById("__ie_init");
    script.onreadystatechange = function() {
        if (this.readyState == "complete") {
            window.fireoninit(); // call the onload handler
        }
    };
    @end @*/

  // for Safari
  if (/WebKit/i.test(navigator.userAgent)) { // sniff
    var _timer = setInterval(function() {
        if (/loaded|complete/.test(document.readyState)) {
            window.fireoninit(); // call the onload handler
        }
    }, 10);
  }

  // for other browsers
  window.onload = window.fireoninit;


/**
 * This is a pseudo Event that will be fired by the fireoninit
 * function above.
 *
 * Use addInitEvent to bind to this event!
 *
 * @author Andreas Gohr <andi@splitbrain.org>
 * @see fireoninit()
 */
window.oninit = function(){};

/**
 * Bind a function to the window.init pseudo event
 *
 * @author Simon Willison
 * @see http://simon.incutio.com/archive/2004/05/26/addLoadEvent
 */
function addInitEvent(func) {
  var oldoninit = window.oninit;
  if (typeof window.oninit != 'function') {
    window.oninit = func;
  } else {
    window.oninit = function() {
      oldoninit();
      func();
    };
  }
}

/*******************************************************************************
 * The LoadingView
 ******************************************************************************/
var loadingView_ = null, loadingView = function()
{
	if ( loadingView_ != null )
	{
		return loadingView_
	}
	
	var self = this;
	this.timeout = null;
	this.timeoutCount = 30;
	loadingView_ = self;
	
	this.show = function()
	{
		// Create basic view
		var view, background, content, loadingImage, loadingText;
		
		view = document.createElement('div');
		view.id = '__loadingView';
		
		background = document.createElement('div');
		background.className = '__loadingViewBackground';
		view.appendChild(background);
		
		content = document.createElement('div');
		content.className = '__loadingViewContent';
		view.appendChild(content);
		
		loadingImage = document.createElement('div');
		loadingImage.className = '__loadingViewImage';
		content.appendChild(loadingImage);
		
		loadingText = document.createElement('span');
		loadingText.appendChild(document.createTextNode('Loading ...'));
		content.appendChild(loadingText);

		document.getElementsByTagName('body')[0].appendChild(view);
		
		this.checkForGWT(); 
	};
	
	this.checkForGWT = function()
	{
		var gwt = document.getElementById('baseContent');
		if ( !gwt && self.timeoutCount > 0) {
			self.timeoutCount--;
			self.timeout = setTimeout(self.checkForGWT, 1000);
		} else if ( !gwt ) {
			self.showError();
		} else {
			self.hide();
		}
	};
	
	this.showError = function()
	{
		self.hide();
		var errorViewWrapper, background, errorView, errorHeader, errorMessage; 
		
		errorViewWrapper = document.createElement("div");
		errorViewWrapper.id = "__errorViewWrapper";

		background = document.createElement('div');
		background.className = '__errorViewBackground';
		errorViewWrapper.appendChild(background);
		
		document.getElementsByTagName('body')[0].appendChild(errorViewWrapper);
	
		errorView = document.createElement("div");
		errorView.className = "__errorView";
		errorViewWrapper.appendChild(errorView);

		errorHeader = document.createElement("h1");
		errorHeader.appendChild(document.createTextNode("Could not load the Remote Interface"));
		errorView.appendChild(errorHeader);

		errorMessage = document.createElement("p");
		errorMessage.appendChild(document.createTextNode("Please make sure you are using an up to date browser to view the Remote Interface."));
		errorView.appendChild(errorMessage);
	};

	this.hide = function(loadingViewName)
	{
		clearTimeout(self.timeout);
		if ( !loadingViewName ) {
			loadingViewName = '__loadingView';
		}
		
		var loadingView = document.getElementById('__loadingView');
		if ( loadingView )
		{
			loadingView.parentNode.removeChild(loadingView);
		} else {
			self.hide('__errorViewWrapper');
		}
	};
};

addInitEvent( function() {
	(new loadingView()).show();
});
