//_______________________
// Object DblClickButton

/**
 * Static object/namespace for DblClickButton support.
 * This object/namespace should not be used externally.
 */
DblClickButton = {

	iTimeoutId:null,

    /**
     * Static object/namespace for DblClickButton MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                    	DblClickButton.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        DblClickButton.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
         /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            for (var item = disposeMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	EchoEventProcessor.removeHandler(divElement, "click");
                	EchoEventProcessor.removeHandler(divElement, "dblclick");
                }
            }
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
            for (var item = initMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	EchoEventProcessor.removeHandler(divElement, "click");
                	EchoEventProcessor.addHandler(divElement, "click", "DblClickButton.processClickStart");
                	EchoEventProcessor.addHandler(divElement, "dblclick", "DblClickButton.processDblClick");
                }
            }
        }
        
    },
    
    /**
     * Processes a click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processClickStart: function(echoEvent) {
    	if (!DblClickButton.iTimeoutId) {
   			DblClickButton.iTimeoutId = setTimeout(function() { DblClickButton.processClick(echoEvent); }, 400);
   		} else {
   			DblClickButton.processDblClick(echoEvent);
   		}
    },
    
    /**
     * Processes a click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processClick: function(echoEvent) {
    	DblClickButton.iTimeoutId = null;
   		if (!EchoClientEngine.verifyInput(echoEvent.registeredTarget)) {
            return;
        }
        var componentId = EchoDomUtil.getComponentId(echoEvent.registeredTarget.id);
        EchoClientMessage.setActionValue(componentId, "click");
        EchoServerTransaction.connect();
    },
    
    /**
     * Processes a double click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processDblClick: function(echoEvent) {
    	if (DblClickButton.iTimeoutId) {
    		window.clearTimeout(DblClickButton.iTimeoutId);
    		DblClickButton.iTimeoutId = null;
    	}
   		if (!EchoClientEngine.verifyInput(echoEvent.registeredTarget)) {
            return;
        }
        var componentId = EchoDomUtil.getComponentId(echoEvent.registeredTarget.id);
        EchoClientMessage.setActionValue(componentId, "dblclick");
        EchoServerTransaction.connect();
    }
           
};
