//_______________________
// Object DblClickDragSource

/**
 * Static object/namespace for DblClickDragSource support.
 * This object/namespace should not be used externally.
 */
DblClickDragSource = {

	iTimeoutId:null,
	lastEvent:null,
	elementId:null,
	lastID:null,
	lastEle:null,

    /**
     * Static object/namespace for DblClickDragSource MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                    	DblClickDragSource.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        DblClickDragSource.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
         /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            for (var item = disposeMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                    EchoEventProcessor.removeHandler(divElement, "mousedown");
                    EchoEventProcessor.removeHandler(divElement, "mouseup");
                    EchoEventProcessor.removeHandler(divElement, "click");
                    EchoDomUtil.removeEventListener(document, "mouseup", DblClickDragSource.processMouseUp, false);
                }
            }
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
            for (var item = initMessageElement.firstChild; item; item = item.nextSibling) {
                DblClickDragSource.elementId = item.getAttribute("eid");
                var divElement = document.getElementById(DblClickDragSource.elementId);
                if (divElement) {
                    EchoEventProcessor.removeHandler(divElement, "mousedown");
                    EchoEventProcessor.addHandler(divElement, "click", "DblClickDragSource.processClick", false);
                    EchoEventProcessor.addHandler(divElement, "mousedown", "DblClickDragSource.processMouseDown", false);
                }
            }
        }
        
    },
    
    /**
     * Processes a click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processMouseUp: function(echoEvent) {
    	EchoDomUtil.preventEventDefault(echoEvent);
    	EchoDomUtil.removeEventListener(document, "mouseup", DblClickDragSource.processMouseUp, false);
    	if (DblClickDragSource.iTimeoutId) {
    		window.clearTimeout(DblClickDragSource.iTimeoutId);
    		DblClickDragSource.iTimeoutId = null;
    	}


    	if ( !DblClickDragSource.lastEvent ) {
   			DblClickDragSource.lastEvent = echoEvent;
			DblClickDragSource.lastID = DblClickDragSource.lastEle.id;
   			
   			var customEvent = function () {
   				if (DblClickDragSource.iTimeoutId) {
		    		window.clearTimeout(DblClickDragSource.iTimeoutId);
    				DblClickDragSource.iTimeoutId = null;
    			}
	   			DblClickDragSource.lastEvent = null;

	   			var trElement = document.getElementById(DblClickDragSource.elementId);
	   			EchoEventProcessor.removeHandler(trElement, "mouseup");
	   			EchoEventProcessor.addHandler(trElement, "mouseup", "ExtrasDragSource.processMouseUp");
	   			if ( document.createEventObject ) {
	   				// IE
	   				var evt = document.createEventObject();
	   				trElement.fireEvent("onmouseup", evt);
	   			} else {
	   				var evt = document.createEvent("HTMLEvents");
	   				evt.initEvent("mouseup", true, true);
	   				trElement.dispatchEvent(evt);
	   			}
	   			EchoEventProcessor.removeHandler(trElement, "mouseup");
	   			EchoEventProcessor.addHandler(trElement, "mouseup", "DblClickDragSource.processMouseUp");
	   		}
   			
   			DblClickDragSource.iTimeoutId = setTimeout(customEvent, 400 );
   			return;
   		}	
    	
   		ExtrasDragSource.processMouseUp(echoEvent);
    	if ( DblClickDragSource.lastID != DblClickDragSource.elementId ) {
 		   	DblClickDragSource.lastEvent = null;
 		   	DblClickDragSource.lastID = null;
    		return;
    	}
    	
    	if (!EchoClientEngine.verifyInput(echoEvent.registeredTarget)) {
            return;
        }

    	EchoClientMessage.setActionValue(DblClickDragSource.elementId, "dblclick");
        EchoServerTransaction.connect();
    	DblClickDragSource.lastEvent = null;
    	DblClickDragSource.lastID = null;
    },
    
    /**
     * Processes a double click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processMouseDown: function(echoEvent) {
    	DblClickDragSource.lastEle = echoEvent.registeredTarget;
    	DblClickDragSource.elementId = echoEvent.registeredTarget.id;
    	ExtrasDragSource.processMouseDown(echoEvent);
        EchoDomUtil.addEventListener(document, "mouseup", DblClickDragSource.processMouseUp, false);
    },
    
    /**
     * Processes a double click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processClick: function(echoEvent) {
    	EchoDomUtil.stopPropagation(echoEvent);
    	EchoDomUtil.preventEventDefault(echoEvent);
    }
    
};
