//_______________________
// Object DblClickTable

/**
 * Static object/namespace for DblClickTable support.
 * This object/namespace should not be used externally.
 */
DblClickTable = {

	iTimeoutId:null,
	lastEvent:null,
	elementId:null,

    /**
     * Static object/namespace for DblClickTable MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                    	DblClickTable.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        DblClickTable.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
         /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            for (var item = disposeMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	var trChildren = divElement.getElementsByTagName("tr");
		            for (var rowIndex = 0; rowIndex < trChildren.length; rowIndex++) {
		                var trElement = trChildren[rowIndex];
		                if (typeof trElement == "undefined") {
		                	continue;
		                }
	                    EchoEventProcessor.removeHandler(trElement, "click");
	                    EchoEventProcessor.removeHandler(trElement, "dblclick");
		            }
                }
            }
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
            for (var item = initMessageElement.firstChild; item; item = item.nextSibling) {
                DblClickTable.elementId = item.getAttribute("eid");
                var divElement = document.getElementById(DblClickTable.elementId);
                if (divElement) {
                	
                	var trChildren = divElement.getElementsByTagName("tr");
		            for (var rowIndex = 0; rowIndex < trChildren.length; rowIndex++) {
		                var trElement = trChildren[rowIndex];
		                if (typeof trElement == "undefined") {
		                	continue;
		                }
	                    EchoEventProcessor.removeHandler(trElement, "click");
	                    EchoEventProcessor.addHandler(trElement, "click", "DblClickTable.processClickStart");
	                    EchoEventProcessor.addHandler(trElement, "dblclick", "DblClickTable.processDblClick");
		            }
		            
                }
            }
        }
        
    },
    
    /**
     * Processes a click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processClickStart: function(echoEvent) {
    	
    	if (DblClickTable.iTimeoutId) {
    		window.clearTimeout(DblClickTable.iTimeoutId);
    		DblClickTable.iTimeoutId = null;
    	}

    	if ( !DblClickTable.lastEvent ) {
   			DblClickTable.lastEvent = echoEvent;
   			
   			var customEvent = function () {
	   			DblClickTable.lastEvent = null;

	   			var trElement = echoEvent.registeredTarget;
	   			EchoEventProcessor.removeHandler(trElement, "click");
	   			EchoEventProcessor.addHandler(trElement, "click", "EchoTable.processClick");
	   			if ( document.createEventObject ) {
	   				// IE
	   				var evt = document.createEventObject();
	   				trElement.fireEvent("onclick", evt);
	   			} else {
	   				var evt = document.createEvent("HTMLEvents");
	   				evt.initEvent("click", true, true);
	   				trElement.dispatchEvent(evt);
	   			}
	   			EchoEventProcessor.removeHandler(trElement, "click");
	   			EchoEventProcessor.addHandler(trElement, "click", "DblClickTable.processClickStart");
	   		}
   			
   			DblClickTable.iTimeoutId = setTimeout(customEvent, 400 );
   			return;
   		}	
    	
    	if (!EchoClientEngine.verifyInput(echoEvent.registeredTarget)) {
            return;
        }
        
    	EchoClientMessage.setActionValue(DblClickTable.elementId, "dblclick");
        EchoTable.processClick(echoEvent);
    	DblClickTable.lastEvent = null;
    },
    
    /**
     * Processes a double click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processDblClick: function(echoEvent) {
    	if (DblClickTable.iTimeoutId) {
    		window.clearTimeout(DblClickTable.iTimeoutId);
    		DblClickTable.iTimeoutId = null;
    	}
   		if (!EchoClientEngine.verifyInput(echoEvent.registeredTarget)) {
            return;
        }
    	EchoClientMessage.setActionValue(DblClickTable.elementId, "dblclick");
        EchoTable.processClick(echoEvent);
    	DblClickTable.lastEvent = null;
    }
           
};
