//_______________________
// Object GWTComponent

/**
 * Static object/namespace for GWT integration.
 * This object/namespace should not be used externally.
 */
GWTComponent = {

    /**
     * Static object/namespace for GWTComponent MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                    	GWTComponent.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        GWTComponent.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
         /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
        	alert( initMessageElement.firstChild.data );
        	alert( jsonData );
        	eval( initMessageElement.firstChild.data );
        	alert( jsonData );
        	if (document.createElement && document.getElementsByTagName) {
   	            var script = document.createElement('script');
       	        script.type = 'text/javascript';
           	    script.src = initMessageElement.getAttribute('javascriptURI');
               	var bodies = document.getElementsByTagName('body');
                if (bodies && bodies[0]) {
   	                bodies[0].appendChild(script);
					GWTComponent.MessageProcessor.startApplication();
           	    }
       		}
		},
			
		startApplication: function(){
			try{
   				prompt.onInjectionDone('prompt');
				if ( !document.createEventObject ) {
   					var evt = document.createEvent("HTMLEvents");
   					evt.initEvent("DOMContentLoaded", true, true);
   					document.dispatchEvent(evt);
	   			}
   			} catch ( e ) {
   				window.setTimeout('GWTComponent.MessageProcessor.startApplication()', 50 );
   			} 
		}
        
    }
};
