//_______________________
// Object HeightDetermineButton

/**
 * Static object/namespace for HeightDetermineButton support.
 * This object/namespace should not be used externally.
 */
HeightDetermineButton = {

	dhid:null,

    /**
     * Static object/namespace for HeightDetermineButton MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                    	HeightDetermineButton.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        HeightDetermineButton.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
         /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            for (var item = disposeMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	HeightDetermineButton.dhid = null;
                	EchoEventProcessor.removeHandler(divElement, "mousedown");
                }
            }
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
            for (var item = initMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	HeightDetermineButton.dhid = item.parentNode.getAttribute("dhid");
                	EchoEventProcessor.addHandler(divElement, "mousedown", "HeightDetermineButton.processMouseDown");
                }
            }
        }
        
    },
    
    /**
     * Processes a mousedown event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processMouseDown: function(echoEvent) {
    	var element = document.getElementById(HeightDetermineButton.dhid);
        EchoClientMessage.setPropertyValue(echoEvent.registeredTarget.id, "determinedHeight", element.offsetHeight + "px");
    }
           
};
