//_______________________
// Object EchoInetContentPane

/**
 * Static object/namespace for ContentPane support.
 * This object/namespace should not be used externally.
 */
EchoInetContentPane = {

	oldwidth:0,
	oldheight:0,

    /**
     * Static object/namespace for ContentPane MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                    	EchoInetContentPane.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        EchoInetContentPane.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
         /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            for (var item = disposeMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	EchoEventProcessor.removeHandler(divElement, "mouseleave");
                	EchoEventProcessor.removeHandler(divElement, "mouseout");
                }
            }
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
            for (var item = initMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	EchoEventProcessor.addHandler(divElement, "mouseleave", "EchoInetContentPane.processResize");
                	EchoEventProcessor.addHandler(divElement, "mouseout", "EchoInetContentPane.processResize");
                }
            }
        }
        
    },
    
    /**
     * Processes a scrollbar adjustment event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processResize: function(echoEvent) {
        if (!EchoClientEngine.verifyInput(echoEvent.registeredTarget)) {
            return;
        }
        var componentId = EchoDomUtil.getComponentId(echoEvent.registeredTarget.id);
        var changed = false;
        if ( echoEvent.registeredTarget.offsetHeight != this.oldheight ) {
        	EchoClientMessage.setPropertyValue(componentId, "height", echoEvent.registeredTarget.offsetHeight + "px");
        	this.oldheight = echoEvent.registeredTarget.offsetHeight;
        	changed = true;
        }
        if ( echoEvent.registeredTarget.offsetWidth != this.oldwidth ) {
            EchoClientMessage.setPropertyValue(componentId, "width", echoEvent.registeredTarget.offsetWidth + "px");
            this.oldwidth = echoEvent.registeredTarget.offsetWidth;
            changed = true;
        }
        if (changed == true) {
        	EchoServerTransaction.connect();
        }
    }
           
};
