//_______________________
// Object EchoMouseOverTarget

/**
 * Static object/namespace for MouseOverTarget support.
 * This object/namespace should not be used externally.
 */
EchoMouseOverTarget = {

	moMapping:{},
	moCMapping:{},
	previewElement:null,
	originalSrc:null,
	lastBorder:null,

    /**
     * Static object/namespace for ContentPane MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                    	EchoMouseOverTarget.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        EchoMouseOverTarget.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
         /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            for (var item = disposeMessageElement.firstChild; item; item = item.nextSibling) {
            	var overTargets = item.parentNode.getAttribute("overTargets");
            	var parts = overTargets.split("|");
            	for ( var i=0; i<parts.length; i++) {
            		var moId = parts[i];
        			var moElement = document.getElementById(moId);
        			if ( moElement ) {
        				EchoMouseOverTarget.moMapping[moId] = null;
        				EchoMouseOverTarget.moCMapping[moId] = null;
        				EchoEventProcessor.removeHandler(moElement, "mouseout");
            			EchoEventProcessor.removeHandler(moElement, "mouseover");
        			}
            	} 
            }
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
            for (var item = initMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	EchoMouseOverTarget.previewElement = divElement;
                	EchoMouseOverTarget.originalSrc = divElement.src;
                	var overTargets = item.parentNode.getAttribute("overTargets");
                	var parts = overTargets.split("|");
                	for ( var i=0; i<parts.length; i++) {
                		var part = parts[i];
                		var index = part.indexOf("=");
                		if ( index > 0 ) {
                			var moId = part.substring(0,index);
                			part = part.substring(index+1);
                			index = part.indexOf("=");
                			var col = part.substring(0,index);
                			var serviceuri = part.substring(index+1);
                			var moElement = document.getElementById(moId);
                			if ( moElement ) {
                				EchoMouseOverTarget.moMapping[moId] = serviceuri;
                				EchoMouseOverTarget.moCMapping[moId] = col;
                				EchoEventProcessor.addHandler(moElement, "mouseover", "EchoMouseOverTarget.processMouseEnter");
                				EchoEventProcessor.addHandler(moElement, "mouseout", "EchoMouseOverTarget.processMouseLeave");
                			}
                		}
                	} 
                }
            }
        }
        
    },
     
    /**
     * Processes a mouse enter adjustment event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processMouseEnter: function(echoEvent) {
        var componentId = EchoDomUtil.getComponentId(echoEvent.registeredTarget.id);
        var serviceuri = EchoMouseOverTarget.moMapping[componentId];
        if ( !serviceuri ) {
        	return;
        }
        EchoMouseOverTarget.previewElement.src = serviceuri;
        
        EchoMouseOverTarget.lastBorder = echoEvent.registeredTarget.style.borderColor;
        
        var tdChildren = echoEvent.registeredTarget.getElementsByTagName("td");
	    for (var rowIndex = 0; rowIndex < tdChildren.length; rowIndex++) {
	        var tdElement = tdChildren[rowIndex];
	        if (typeof tdElement == "undefined") {
	        	continue;
	        }
	        tdElement.style.borderColor = EchoMouseOverTarget.moCMapping[componentId];
	    }
        
        echoEvent.registeredTarget.style.borderColor = EchoMouseOverTarget.moCMapping[componentId];
    },
    
    /**
     * Processes a scrollbar adjustment event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processMouseLeave: function(echoEvent) {
    	EchoMouseOverTarget.previewElement.src = EchoMouseOverTarget.originalSrc;
    	var tdChildren = echoEvent.registeredTarget.getElementsByTagName("td");
	    for (var rowIndex = 0; rowIndex < tdChildren.length; rowIndex++) {
	        var tdElement = tdChildren[rowIndex];
	        if (typeof tdElement == "undefined") {
	        	continue;
	        }
	        tdElement.style.borderColor = EchoMouseOverTarget.lastBorder;
	    }
		echoEvent.registeredTarget.style.borderColor = EchoMouseOverTarget.lastBorder;
    }
           
};
