//_______________________
// Object EchoPreventSelectionSplitPane

/**
 * Static object/namespace for PreventSelectionSplitPane support.
 * This object/namespace should not be used externally.
 */
EchoPreventSelectionSplitPane = {
    
    iTimeoutId:null,
    
    /**
     * Static object/namespace for PreventSelectionSplitPane MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                        EchoPreventSelectionSplitPane.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        EchoPreventSelectionSplitPane.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
        /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            for (var item = disposeMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (!divElement) {
                    continue;
                }
                var contentElement = EchoPreventSelectionSplitPane.findContentElement(divElement);
                if (!contentElement) {
                    continue;
                }
                EchoEventProcessor.removeHandler(contentElement, "mousedown");
                EchoEventProcessor.removeHandler(contentElement, "mouseup");
            }
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
            for (var item = initMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                var contentElement = EchoPreventSelectionSplitPane.findContentElement(divElement);
                EchoDomUtil.addEventListener(contentElement, "mousedown", EchoPreventSelectionSplitPane.processMouseDown, false);
                EchoDomUtil.addEventListener(contentElement, "mouseup", EchoPreventSelectionSplitPane.processMouseUp, false);
            }
        }
        
    },
        
    /**
     * Finds the separator element of a SplitPane.
     * @param element the root SplitPane DIV element to search.
     * @return the separator DIV element, if found
     */
    findContentElement: function(element) {
        for (var child = element.firstChild; child; child = child.nextSibling) {
            if (child.id && child.id.indexOf("_separator") != -1) {
                return child;
            }
        }
        return null;
    },
    
    /**
     * Processes a mouse move event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processMouseMove: function(echoEvent) {
    	window.setTimeout(function() {
	    	if (window.getSelection()) {
	    		window.getSelection().removeAllRanges();
	    	}
	    	if (document.selection) {
	    		document.selection.empty();
	    	}
	    }
	    , 50 );
    },
    
    /**
     * Processes a mouse down event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processMouseDown: function(echoEvent) {
        EchoDomUtil.addEventListener(document, "mousemove", EchoPreventSelectionSplitPane.processMouseMove, false);
        EchoDomUtil.addEventListener(document, "mouseup", EchoPreventSelectionSplitPane.processMouseUp, false);
    },
    
    /**
     * Processes a mouse up event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processMouseUp: function(echoEvent) {
    	EchoDomUtil.removeEventListener(document, "mousemove", EchoPreventSelectionSplitPane.processMouseMove, false);
    	EchoDomUtil.removeEventListener(document, "mouseup", EchoPreventSelectionSplitPane.processMouseUp, false);
    	EchoPreventSelectionSplitPane.processMouseMove(echoEvent);
    }
};
