//_______________________
// Object SortDblClickTable

/**
 * Static object/namespace for SortDblClickTable support.
 * This object/namespace should not be used externally.
 */
SortDblClickTable = {

	iTimeoutId:null,
	lastEvent:null,
	elementId:null,

    /**
     * Static object/namespace for SortDblClickTable MessageProcessor 
     * implementation.
     */
    MessageProcessor: {
    
        /**
         * MessageProcessor process() implementation 
         * (invoked by ServerMessage processor).
         *
         * @param messagePartElement the <code>message-part</code> element to process.
         */
        process: function(messagePartElement) {
            for (var i = 0; i < messagePartElement.childNodes.length; ++i) {
                if (messagePartElement.childNodes[i].nodeType == 1) {
                    switch (messagePartElement.childNodes[i].tagName) {
                    case "init":
                    	SortDblClickTable.MessageProcessor.processInit(messagePartElement.childNodes[i]);
                        break;
                    case "dispose":
                        SortDblClickTable.MessageProcessor.processDispose(messagePartElement.childNodes[i]);
                        break;
                    }
                }
            }
        },
        
         /**
         * Processes a <code>dispose</code> message to finalize the state of a
         * selection component that is being removed.
         *
         * @param disposeMessageElement the <code>dispose</code> element to process
         */
        processDispose: function(disposeMessageElement) {
            for (var item = disposeMessageElement.firstChild; item; item = item.nextSibling) {
                var elementId = item.getAttribute("eid");
                var divElement = document.getElementById(elementId);
                if (divElement) {
                	var trChildren = divElement.getElementsByTagName("tr");
		            for (var rowIndex = 0; rowIndex < trChildren.length; rowIndex++) {
		                var trElement = trChildren[rowIndex];
		                if (typeof trElement == "undefined") {
		                	continue;
		                }
	                    EchoEventProcessor.removeHandler(trElement, "click");
	                    EchoEventProcessor.removeHandler(trElement, "dblclick");
		            }
                }
            }
        },
        
        /**
         * Processes an <code>init</code> message to initialize the state of a 
         * selection component that is being added.
         *
         * @param initMessageElement the <code>init</code> element to process
         */
        processInit: function(initMessageElement) {
            for (var item = initMessageElement.firstChild; item; item = item.nextSibling) {
                SortDblClickTable.elementId = item.getAttribute("eid");
                var divElement = document.getElementById(SortDblClickTable.elementId);
                if (divElement) {
                	
                	var trChildren = divElement.getElementsByTagName("tr");
		            for (var rowIndex = 0; rowIndex < trChildren.length; rowIndex++) {
		                var trElement = trChildren[rowIndex];
		                if (typeof trElement == "undefined") {
		                	continue;
		                }
	                    EP.Event.removeHandler('click',trElement);
	                    EchoEventProcessor.addHandler(trElement, "click", "SortDblClickTable.processClickStart");
	                    EchoEventProcessor.addHandler(trElement, "dblclick", "SortDblClickTable.processDblClick");
		            }
		            
                }
            }
        }
        
    },
    
    /**
     */
    forwardClickEvent : function(echoEvent) {
		var trElement = echoEvent.registeredTarget;
		var identifiedTarget = echoEvent.target || echoEvent.srcElement || trElement;
		
		EchoEventProcessor.removeHandler(trElement, "click");
		EP.Event.addHandler('click',trElement, function(echoEvent) {EPTableEx.prototype.processClick(echoEvent);});
		if ( document.createEventObject ) {
			// IE
			var evt = document.createEventObject();
			identifiedTarget.fireEvent("onclick", evt);
		} else {
			var evt = document.createEvent("HTMLEvents");
			evt.initEvent("click", true, true);
			identifiedTarget.dispatchEvent(evt);
		}
		EP.Event.removeHandler('click',trElement);
		EchoEventProcessor.addHandler(trElement, "click", "SortDblClickTable.processClickStart");
    },
    
    /**
     * Processes a click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processClickStart: function(echoEvent) {
    	if (SortDblClickTable.iTimeoutId) {
    		window.clearTimeout(SortDblClickTable.iTimeoutId);
    		SortDblClickTable.iTimeoutId = null;
    	}

    	if ( !SortDblClickTable.lastEvent ) {
   			SortDblClickTable.lastEvent = echoEvent;
   			
   			var customEvent = function () {
	   			SortDblClickTable.lastEvent = null;
				SortDblClickTable.forwardClickEvent(echoEvent);
	   		}
   			
   			SortDblClickTable.iTimeoutId = setTimeout(customEvent, 400 );
   			return;
   		}	
    	
    	if (!EchoClientEngine.verifyInput(echoEvent.registeredTarget)) {
            return;
        }
    	EchoClientMessage.setActionValue(SortDblClickTable.elementId, "dblclick");
    	SortDblClickTable.forwardClickEvent(echoEvent);
    	SortDblClickTable.lastEvent = null;
    },
    
    /**
     * Processes a double click event.
     *
     * @param echoEvent the event, preprocessed by the 
     *        <code>EchoEventProcessor</code>
     */
    processDblClick: function(echoEvent) {
    	if (SortDblClickTable.iTimeoutId) {
    		window.clearTimeout(SortDblClickTable.iTimeoutId);
    		SortDblClickTable.iTimeoutId = null;
    	}
   		if (!EchoClientEngine.verifyInput(echoEvent.registeredTarget)) {
            return;
        }
    	EchoClientMessage.setActionValue(SortDblClickTable.elementId, "dblclick");
        SortDblClickTable.forwardClickEvent(echoEvent);
    	SortDblClickTable.lastEvent = null;
    }
           
};
