<?php

function getDayOfWeek($cdate = ""){
	if(($cdate != "" && $this->validDate($cdate)) || $cdate == ""){
		$tmp_date = ($cdate != "") ? strtotime($cdate) : $this->mydate;
		return date('w', $tmp_date);
	}
}
	
function dateOfWeek($Ymd, $day) {
	global $week_start_day;
	if (!isset($week_start_day)) $week_start_day = 'Sunday';
	$timestamp = strtotime($Ymd);
	$num = date('w', strtotime($week_start_day));
	$start_day_time = strtotime((date('w',$timestamp)==$num ? "$week_start_day" : "last $week_start_day"), $timestamp);
	$ret_unixtime = strtotime($day,$start_day_time);
	$ret_unixtime = strtotime('+12 hours', $ret_unixtime);
	$ret = date('Ymd',$ret_unixtime);
	return $ret;
}

// function to compare to dates in Ymd and return the number of weeks 
// that differ between them. requires dateOfWeek()
function weekCompare($now, $then) {
	global $week_start_day;
	$sun_now = dateOfWeek($now, $week_start_day);
	$sun_then = dateOfWeek($then, $week_start_day);
	$seconds_now = strtotime($sun_now);
	$seconds_then =  strtotime($sun_then);
	$diff_seconds = $seconds_now - $seconds_then;
	$diff_minutes = $diff_seconds/60;
	$diff_hours = $diff_minutes/60;
	$diff_days = round($diff_hours/24);
	$diff_weeks = $diff_days/7;
	
	return $diff_weeks;
}

// function to compare to dates in Ymd and return the number of days 
// that differ between them.
function dayCompare($now, $then) {
	$seconds_now = strtotime($now);
	$seconds_then =  strtotime($then);
	$diff_seconds = $seconds_now - $seconds_then;
	$diff_minutes = $diff_seconds/60;
	$diff_hours = $diff_minutes/60;
	$diff_days = round($diff_hours/24);
	
	return $diff_days;
}

// function to compare to dates in Ymd and return the number of months 
// that differ between them.
function monthCompare($now, $then) {
	ereg ("([0-9]{4})([0-9]{2})([0-9]{2})", $now, $date_now);
	ereg ("([0-9]{4})([0-9]{2})([0-9]{2})", $then, $date_then);
	$diff_years = $date_now[1] - $date_then[1];
	$diff_months = $date_now[2] - $date_then[2];
	if ($date_now[2] < $date_then[2]) {
		$diff_years -= 1;
		$diff_months = ($diff_months + 12) % 12;
	}
	$diff_months = ($diff_years * 12) + $diff_months;

	return $diff_months;
}

function yearCompare($now, $then) {
	ereg ("([0-9]{4})([0-9]{2})([0-9]{2})", $now, $date_now);
	ereg ("([0-9]{4})([0-9]{2})([0-9]{2})", $then, $date_then);
	$diff_years = $date_now[1] - $date_then[1];
	return $diff_years;
}
 

function getDaysInMonth(year, month) {
    var m = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    if (month != 2) return m[month - 1];
    if (year % 4 != 0) return m[1];
    if (year % 100 == 0 && year % 400 != 0) return m[1];
    return m[1] + 1;
}

	//check if date1 is before date2
	//if date1 omitted use set date
	function dateBefore($date2, $date1 = "", $equal = true){
		if($this->validDate($date2)){
			$date1 = ($date1 != "") ? strtotime($date1) : $this->mydate;
			$date2 = strtotime($date2);
			return ($equal) ? $date1<=$date2 : $date1<$date2;
		}else return false;
	}
	
	//check if date1 is after date2
	//if date1 omitted use set date
	function dateAfter($date2, $date1 = "", $equal = true){
		if($this->validDate($date2)){
			$date1 = ($date1 != "") ? strtotime($date1) : $this->mydate;
			$date2 = strtotime($date2);
			return ($equal) ? $date1>=$date2 : $date1>$date2;
		}else return false;
	}

	function validDate($date_str){
		if($date_str != ""){
			$date_arr = explode("-", $date_str, 3);

			if((isset($date_arr[0]) && is_numeric($date_arr[0])) && (isset($date_arr[1]) && is_numeric($date_arr[1])) && (isset($date_arr[2]) && is_numeric($date_arr[2]))){
				return (checkdate($date_arr[1], $date_arr[2], $date_arr[0])) ? true : false;
			}else return false;
		}else return false;
	}
?>

 